function T = generate_sparse_tensor(N, s)
    % Total number of elements
    total_elements = prod(N);

    % Randomly choose s unique linear indices
    lin_idx = randsample(total_elements, s);

    % Generate s standard normal values
    values = randn(s, 1);

    % Create full zero tensor and assign values
    T = zeros(N.');
    T(lin_idx) = values;
end