function tX = generate_kro_supp_sparse_tensor(N, K)
I = length(N);
    supp = cell(I, 1);

    for i = 1:I
        supp{i} = randsample(N(i), K(i));
    end

    [grid{1:I}] = ndgrid(supp{:});
    subs = cellfun(@(x) x(:), grid, 'UniformOutput', false);  % each is a column vector
    subs = [subs{:}];  % s × I matrix, where s = prod(K)

    values = randn(prod(K), 1);

    tX = zeros(N.');
    for j = 1:prod(K)
        idx = num2cell(subs(j, :));
        tX(idx{:}) = values(j);
    end
end