function tX = generate_hierarchical_sparse_tensor(N, K)
tX = recursive_fill(N, K);
end


function subtensor = recursive_fill(N, K)
    I = length(N);

    if I == 1
        subtensor = zeros(N(1), 1);
        active_idx = randsample(N(1), K(1));
        subtensor(active_idx) = randn(K(1), 1);
        return;
    end

    subtensor = zeros(N.');

    active_indices = randsample(N(I), K(I));

    for idx = active_indices.'
        slice_idx = repmat({':'}, 1, I);
        slice_idx{I} = idx;

        lower_tensor = recursive_fill(N(1:I-1), K(1:I-1));

        subtensor(slice_idx{:}) = lower_tensor;
    end
end