%% 1a: plot
clc
clear
load s_sparse_snr.mat

all_colors = [
    0,      70/255, 222/255;
    0.6350, 0.0780, 0.1840;
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-*';
line_type_set{2} = '-p';
line_type_set{3} = '-o';
line_type_set{4} = '-x';
algo_name{1} = 'MSOMP';
algo_name{2} = 'KroOMP';
algo_name{3} = 'MSSBL-Seq';
algo_name{4} = 'MSSBL-Pl';

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

fontsizeman = 20;
figure_position = [100, 100, 600, 400]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse = figure('Position', figure_position);
ax1 = gca;
hold(ax1, 'on'); 
for algo_index = 1:3
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end

    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none', 'HandleVisibility', 'off');
    plot(ax1, SNR, errorTotal(:, algo_index), line_type_set{algo_index}, 'Color', all_colors(algo_index, :));
end

h1 = plot(ax1, NaN, NaN, '-*', 'Color', all_colors(1, :), 'LineStyle', 'none', 'DisplayName', algo_name{1});
h2 = plot(ax1, NaN, NaN, '-p', 'Color', all_colors(2, :), 'LineStyle', 'none', 'DisplayName', algo_name{2});
h3 = plot(ax1, NaN, NaN, '-o', 'Color', all_colors(3, :), 'LineStyle', 'none', 'DisplayName', algo_name{3});
% h4 = plot(ax1, NaN, NaN, '-x', 'Color', all_colors(4, :), 'LineStyle', 'none', 'DisplayName', algo_name{4});
legend([h1, h2, h3], 'Location', 'southwest', 'Interpreter', 'latex', 'Box', 'off');
hold(ax1, 'off');

ylim([1e-5 1e2])

set(ax1, 'YScale', 'log', 'XLim', [3 25]);
ylabel(ax1, 'NSE');
xlabel(ax1, 'SNR (dB)');
grid(ax1, 'on');
box(ax1, 'on');
exportgraphics(f_nmse, 's_standard_nmse.pdf', 'ContentType', 'vector');

f_srr = figure('Position', figure_position);
ax2 = gca;
hold(ax2, 'on');
for algo_index = 1:4
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end

    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);


    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, SNR, srrTotal(:, algo_index), line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [3 25], 'YLim', [0 1]);
ylabel(ax2, 'SRR');
xlabel(ax2, 'SNR (dB)');
grid(ax2, 'on');
box(ax2, 'on');
exportgraphics(f_srr, 's_standard_srr.pdf', 'ContentType', 'vector');

f_time = figure('Position', figure_position);
ax3 = gca;
hold(ax3, 'on');
for algo_index = 1:3
    % upper_bound = timeTotal(:, algo_index) + timeStd(:, algo_index);
    % lower_bound = timeTotal(:, algo_index) - timeStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(timeTotal(:, algo_index)));
    % end
    upper_bound = timeQ1(:, algo_index);
    lower_bound = timeQ3(:, algo_index);

    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax3, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax3, SNR,timeTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax3, 'off');
xlim(ax3, [3 25]);
grid(ax3, 'on');
set(ax3, 'yscale', 'log');
xlabel(ax3, 'SNR (dB)');
ylabel(ax3, 'Time');
box(ax3, 'on');
exportgraphics(f_time,'s_standard_time.pdf','ContentType', 'vector');

%% 1b: plot
clc
clear
load s_sparse_measurement.mat

all_colors = [
    0,      70/255, 222/255;
    0.6350, 0.0780, 0.1840;
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-*';
line_type_set{2} = '-p';
line_type_set{3} = '-o';
line_type_set{4} = '-x';
algo_name{1} = 'MSOMP';
algo_name{2} = 'KroOMP';
algo_name{3} = 'MSSBL-Seq';
algo_name{4} = 'MSSBL-Pl';

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));


ratio = M_candidate.^I/Nbar;

fontsizeman = 20;
figure_position = [100, 100, 600, 400]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse = figure('Position', figure_position);
ax1 = gca;
hold(ax1, 'on'); 
for algo_index = 1:3
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none', 'HandleVisibility', 'off');
    plot(ax1, ratio, errorTotal(:, algo_index), line_type_set{algo_index}, 'Color', all_colors(algo_index, :));
end

h1 = plot(ax1, NaN, NaN, '-*', 'Color', all_colors(1, :), 'LineStyle', 'none', 'DisplayName', algo_name{1});
h2 = plot(ax1, NaN, NaN, '-p', 'Color', all_colors(2, :), 'LineStyle', 'none', 'DisplayName', algo_name{2});
h3 = plot(ax1, NaN, NaN, '-o', 'Color', all_colors(3, :), 'LineStyle', 'none', 'DisplayName', algo_name{3});
% h4 = plot(ax1, NaN, NaN, '-x', 'Color', all_colors(4, :), 'LineStyle', 'none', 'DisplayName', algo_name{4});
legend([h1, h2, h3], 'Location', 'southwest', 'Interpreter', 'latex', 'Box', 'off');
hold(ax1, 'off');

set(ax1, 'YScale', 'log', 'XLim', [0.35 0.83]);
ylabel(ax1, 'NSE');
xlabel(ax1, 'Ratio');
grid(ax1, 'on');
box(ax1, 'on');
exportgraphics(f_nmse, 's_standard_mea_nmse.pdf', 'ContentType', 'vector');

f_srr = figure('Position', figure_position);
ax2 = gca;
hold(ax2, 'on');
for algo_index = 1:4
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end
    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, ratio, srrTotal(:, algo_index), line_type_set{algo_index}, 'Color', all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [0.35 0.83]);
ylabel(ax2, 'SRR');
xlabel(ax2, 'Ratio');
grid(ax2, 'on');
box(ax2, 'on');
exportgraphics(f_srr, 's_standard_mea_srr.pdf', 'ContentType', 'vector');

f_time = figure('Position', figure_position);
ax3 = gca;
hold(ax3, 'on');
for algo_index = 1:4
    % upper_bound = timeTotal(:, algo_index) + timeStd(:, algo_index);
    % lower_bound = timeTotal(:, algo_index) - timeStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(timeTotal(:, algo_index)));
    % end
    upper_bound = timeQ3(:, algo_index);
    lower_bound = timeQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax3, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax3, ratio, timeTotal(:,algo_index), line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax3, 'off');
xlim(ax3, [0.35 0.83]);
grid(ax3, 'on');
set(ax3, 'yscale', 'log');
xlabel(ax3, 'Ratio');
ylabel(ax3, 'Time');
box(ax3, 'on');
exportgraphics(f_time,'s_standard_mea_time.pdf','ContentType', 'vector');


%% 2a: plot
clc
clear
load hie_s_snr.mat

all_colors = [
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.6350, 0.0780, 0.1840;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-o';
line_type_set{2} = '-x';
line_type_set{3} = '->';
line_type_set{4} = '-h';
line_type_set{5} = '-<';
line_type_set{6} = '-^';
line_type_set{7} = '-v';
legend_type_set{1} = 'o';
legend_type_set{2} = 'x';
legend_type_set{3} = '>';
legend_type_set{4} = 'h';
legend_type_set{5} = '<';
legend_type_set{6} = '^';
legend_type_set{7} = 'v';
algo_name{1} = 'MSSBL-Seq';
algo_name{2} = 'MSSBL-Pl';
algo_name{3} = 'MSHTP-Seq';
algo_name{4} = 'HiHTP';
algo_name{5} = 'HTP';
algo_name{6} = 'MSIHT-Seq';
algo_name{7} = 'IHT';

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

fontsizeman = 20;
figure_position = [100, 100, 600, 400]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse = figure('Position', figure_position);
ax1 = gca;
hold(ax1, 'on'); 

% line1 = plot(ax1, SNR,errorTotal(:,1),'-','Color',[0,0,0]);
% line2 = plot(ax1, SNR,errorTotal(:,2),'-.','Color',[0,0,0]);
for algo_index = 3:7
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end

    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, SNR,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
% h1 = plot(ax1, SNR,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
% h2 = plot(ax1, SNR,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, SNR,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, SNR,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, SNR,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
h6 = plot(ax1, SNR,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
h7 = plot(ax1, SNR,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
% h8 = plot(ax1, NaN,NaN,'-','Color',[1 1 1]);
legend(ax1, [h3 h4 h5 h6 h7],{algo_name{3},algo_name{4},algo_name{5},algo_name{6},algo_name{7}},'Location','southwest','Interpreter','LaTex','Box','off');
ylim([1.1*1e-4 0.5])
set(ax1, 'YScale', 'log', 'XLim', [3 25], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NMSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax1, 'on');
box(ax1, 'on');
ylabel(ax1, 'NSE');
xlabel(ax1, 'SNR (dB)');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);

exportgraphics(f_nmse, 's_hie_nmse.pdf', 'ContentType', 'vector');

f_srr = figure('Position', figure_position);
ax2 = gca;
hold(ax2, 'on');
for algo_index = 3:7
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end

    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, SNR,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
ylim([0.3 1])
set(ax2, 'XLim', [3 25], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'SNR (dB)', 'FontSize', fontsizeman, 'FontWeight', 'bold');

exportgraphics(f_srr, 's_hie_srr.pdf', 'ContentType', 'vector');

f_time = figure('Position', figure_position);
ax3 = gca;
hold(ax3, 'on');
for algo_index = 3:7
    % upper_bound = timeTotal(:, algo_index) + timeStd(:, algo_index);
    % lower_bound = timeTotal(:, algo_index) - timeStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(timeTotal(:, algo_index)));
    % end
    upper_bound = timeQ3(:, algo_index);
    lower_bound = timeQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax3, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax3, SNR, timeTotal(:,algo_index), line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax3, 'off');
xlim(ax3, [3 25]);
grid(ax3, 'on');
set(ax3, 'yscale', 'log');
xlabel(ax3, 'SNR (dB)');
ylabel(ax3, 'Time');
box(ax3, 'on');
exportgraphics(f_time,'s_hie_time.pdf','ContentType', 'vector');

%% 2b: plot
clc
clear
load hie_s_measurement.mat

all_colors = [
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.6350, 0.0780, 0.1840;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-o';
line_type_set{2} = '-x';
line_type_set{3} = '->';
line_type_set{4} = '-h';
line_type_set{5} = '-<';
line_type_set{6} = '-^';
line_type_set{7} = '-v';
legend_type_set{1} = 'o';
legend_type_set{2} = 'x';
legend_type_set{3} = '>';
legend_type_set{4} = 'h';
legend_type_set{5} = '<';
legend_type_set{6} = '^';
legend_type_set{7} = 'v';
algo_name{1} = 'MSSBL-Seq';
algo_name{2} = 'MSSBL-Pl';
algo_name{3} = 'MSHTP';
algo_name{4} = 'HiHTP';
algo_name{5} = 'HTP';
algo_name{6} = 'MSIHT';
algo_name{7} = 'IHT';

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

M_candidate = 48:4:72;
N = 80*ones(I,1);
Nbar = prod(N);
ratio = M_candidate.^I/Nbar;

fontsizeman = 20;
figure_position = [100, 100, 600, 400]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse = figure('Position', figure_position);
ax1 = gca;
hold(ax1, 'on'); 
% line1 = plot(ax1, ratio,errorTotal(:,1),'-','Color',[0,0,0]);
% line2 = plot(ax1, ratio,errorTotal(:,2),'-.','Color',[0,0,0]);
for algo_index = 3:7
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);
    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, ratio,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
% h1 = plot(ax1, ratio,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
% h2 = plot(ax1, ratio,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, ratio,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, ratio,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, ratio,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
h6 = plot(ax1, ratio,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
h7 = plot(ax1, ratio,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
% h8 = plot(ax1, NaN,NaN,'-','Color',[1 1 1]);
legend(ax1, [h3 h4 h5 h6 h7],{algo_name{3},algo_name{4},algo_name{5},algo_name{6},algo_name{7}},'Location','northeast','Interpreter','LaTex','Box','off');
set(ax1, 'YScale', 'log', 'XLim', [.35 .83], 'YLim', [1e-4 10], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');
exportgraphics(f_nmse, 's_hie_mea_nmse.pdf', 'ContentType', 'vector');
xlabel(ax1, 'Ratio');

f_srr = figure('Position', figure_position);
ax2 = gca;
hold(ax2, 'on');
for algo_index = 3:7
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end
    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);
    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, ratio,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [.35 .83], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'Ratio', 'FontSize', fontsizeman, 'FontWeight', 'bold');


exportgraphics(f_srr, 's_hie_mea_srr.pdf', 'ContentType', 'vector');

f_time = figure('Position', figure_position);
ax3 = gca;
hold(ax3, 'on');
for algo_index = 3:7
    % upper_bound = timeTotal(:, algo_index) + timeStd(:, algo_index);
    % lower_bound = timeTotal(:, algo_index) - timeStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(timeTotal(:, algo_index)));
    % end
    upper_bound = timeQ3(:, algo_index);
    lower_bound = timeQ1(:, algo_index);
    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    hold on
    plot(ratio,timeTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
    hold on
end
xlim([.35 .83])
f_time.Units = 'inches';
f_time.Position = [1, 1, 8, 5];
box on
grid on
set(gca, 'yscale', 'log');
set(0,'DefaultLineLineWidth',3)
set(0,'DefaultAxesFontSize',fontsizeman)
set(0,'DefaultLineMarkerSize',fontsizeman)
set(0,'DefaultAxesFontWeight','bold')
set(gca,'FontSize',fontsizeman)
set(get(gca,'Xlabel'),'FontSize',fontsizeman)
set(get(gca,'Ylabel'),'FontSize',fontsizeman)
set(get(gca,'Title'),'FontSize',fontsizeman)
set(get(gca,'Xlabel'),'FontWeight','bold')
set(get(gca,'Ylabel'),'FontWeight','bold')
set(get(gca,'Title'),'FontWeight','bold')
xlabel('Ratio')
ylabel('Time')

exportgraphics(f_time,'s_hie_mea_time.pdf','ContentType', 'vector');


%% 3a: plot
clc
clear
load kro_sup_snr.mat

all_colors = [
    0.0000, 0.2745, 0.8706;  % Original Blue
    1.0000, 0.0000, 1.0000;  % Original Magenta
    0.0000, 0.4470, 0.7410;  % Original Sky Blue
    0.6350, 0.0780, 0.1840;  % Original Maroon
    0.9290, 0.6940, 0.1250;  % Original Yellow
    0.4900, 0.1800, 0.5600;  % Original Purple
    0.5000, 0.5000, 0.5000;  % Original Gray
    0.8500, 0.3250, 0.0980;  % Original Orange
    0.0000, 0.1880, 0.0000   % New Dark Green
];

line_type_set{1} = '-*';
line_type_set{2} = '-.>';
line_type_set{3} = '-o';
line_type_set{4} = '-s';
line_type_set{5} = '-d';
line_type_set{6} = '-.<';
line_type_set{7} = '-.^';
line_type_set{8} = '-.v';
line_type_set{9} = '-.x';

legend_type_set{1} = '*';
legend_type_set{2} = '>';
legend_type_set{3} = 'o';
legend_type_set{4} = 's';
legend_type_set{5} = 'd';
legend_type_set{6} = '<';
legend_type_set{7} = '^';
legend_type_set{8} = 'v';
legend_type_set{9} = 'x';

algo_name{1} = 'MSOMP';
algo_name{2} = 'MSHTP';
algo_name{3} = 'MSSBL';
algo_name{4} = 'SVD-KroSBL';
algo_name{5} = 'AM-KroSBL';
algo_name{6} = 'HTP';
algo_name{7} = 'MSIHT';
algo_name{8} = 'IHT';
algo_name{9} = 'KSHTP';

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

fontsizeman = 20;
figure_position = [100, 100, 600, 400]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse = figure('Position', figure_position);
ax1 = gca;
hold(ax1, 'on'); 

% line1 = plot(ax1, SNR,errorTotal(:,1),'-','Color',[0,0,0]);
% line2 = plot(ax1, SNR,errorTotal(:,2),'-.','Color',[0,0,0]);
% h10 = plot(ax1, SNR,errorTotal(:,7),'-','Color',[1 1 1]);
% h11 = plot(ax1, SNR,errorTotal(:,8),'-.','Color',[1 1 1]);
for algo_index = [1,3,4,5]
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, SNR,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h1 = plot(ax1, SNR,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
% h2 = plot(ax1, SNR,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, SNR,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, SNR,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, SNR,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
% h6 = plot(ax1, SNR,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
% h7 = plot(ax1, SNR,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
% h8 = plot(ax1, SNR,errorTotal(:,8),legend_type_set{8},'Color',all_colors(8, :),'Display',algo_name{8});
% h9 = plot(ax1, SNR,errorTotal(:,9),legend_type_set{9},'Color',all_colors(9, :),'Display',algo_name{9});
lgd = legend(ax1, [h1 h3 h4 h5],...
    {algo_name{1},algo_name{3},algo_name{4},algo_name{5}},...
    'Interpreter','LaTex','Box','off','Location','southwest');
% lgd.Position = [0.04, 0.57, 1, 0.15];
set(ax1, 'YScale', 'log', 'XLim', [3 25], 'YLim', [1e-4 1e2], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');
xlabel(ax1, 'SNR (dB)');
exportgraphics(f_nmse, 's_kro_nmse.pdf', 'ContentType', 'vector');

f_srr = figure('Position', figure_position);
ax2 = gca;
hold(ax2, 'on'); 
for algo_index = [1,3,4,5]
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end
    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, SNR,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [3 25], 'YLim', [0 1], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'SNR (dB)', 'FontSize', fontsizeman, 'FontWeight', 'bold');

exportgraphics(f_srr, 's_kro_srr.pdf', 'ContentType', 'vector');

f_time = figure('Position', figure_position);
ax3 = gca;
hold(ax3, 'on'); 
for algo_index = [1,3,4,5]
    % upper_bound = timeTotal(:, algo_index) + timeStd(:, algo_index);
    % lower_bound = timeTotal(:, algo_index) - timeStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(timeTotal(:, algo_index)));
    % end
    upper_bound = timeQ3(:, algo_index);
    lower_bound = timeQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    hold on
    plot(SNR,timeTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
    hold on
end
xlim([3 25])
f_time.Units = 'inches';
f_time.Position = [1, 1, 8, 5];
box on
grid on
set(gca, 'yscale', 'log');
set(0,'DefaultLineLineWidth',3)
set(0,'DefaultAxesFontSize',fontsizeman)
set(0,'DefaultLineMarkerSize',fontsizeman)
set(0,'DefaultAxesFontWeight','bold')
set(gca,'FontSize',fontsizeman)
set(get(gca,'Xlabel'),'FontSize',fontsizeman)
set(get(gca,'Ylabel'),'FontSize',fontsizeman)
set(get(gca,'Title'),'FontSize',fontsizeman)
set(get(gca,'Xlabel'),'FontWeight','bold')
set(get(gca,'Ylabel'),'FontWeight','bold')
set(get(gca,'Title'),'FontWeight','bold')
xlabel('SNR (dB)')
ylabel('Time')

exportgraphics(f_time,'s_kro_time.pdf','ContentType', 'vector');


%% 3b: plot
clc
clear
load kro_sup_measurement.mat

M_candidate = 12:1:16;
ratio = M_candidate.^I/Nbar;
all_colors = [
    0.0000, 0.2745, 0.8706;  % Original Blue
    1.0000, 0.0000, 1.0000;  % Original Magenta
    0.0000, 0.4470, 0.7410;  % Original Sky Blue
    0.6350, 0.0780, 0.1840;  % Original Maroon
    0.9290, 0.6940, 0.1250;  % Original Yellow
    0.4900, 0.1800, 0.5600;  % Original Purple
    0.5000, 0.5000, 0.5000;  % Original Gray
    0.8500, 0.3250, 0.0980;  % Original Orange
    0.0000, 0.1880, 0.0000   % New Dark Green
];

line_type_set{1} = '-*';
line_type_set{2} = '-.>';
line_type_set{3} = '-o';
line_type_set{4} = '-s';
line_type_set{5} = '-d';
line_type_set{6} = '-.<';
line_type_set{7} = '-.^';
line_type_set{8} = '-.v';
line_type_set{9} = '-.x';

legend_type_set{1} = '*';
legend_type_set{2} = '>';
legend_type_set{3} = 'o';
legend_type_set{4} = 's';
legend_type_set{5} = 'd';
legend_type_set{6} = '<';
legend_type_set{7} = '^';
legend_type_set{8} = 'v';
legend_type_set{9} = 'x';

algo_name{1} = 'MSOMP';
algo_name{2} = 'MSHTP';
algo_name{3} = 'MSSBL';
algo_name{4} = 'SVD-KroSBL';
algo_name{5} = 'AM-KroSBL';
algo_name{6} = 'HTP';
algo_name{7} = 'MSIHT';
algo_name{8} = 'IHT';
algo_name{9} = 'KSHTP';

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

fontsizeman = 20;
figure_position = [100, 100, 600, 400]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse = figure('Position', figure_position);
ax1 = gca;
hold(ax1, 'on'); 

% line1 = plot(ax1, ratio,errorTotal(:,1),'-','Color',[0,0,0]);
% line2 = plot(ax1, ratio,errorTotal(:,2),'-.','Color',[0,0,0]);
for algo_index = [1,3,4,5]
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);
    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, ratio,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h1 = plot(ax1, ratio,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
% h2 = plot(ax1, ratio,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, ratio,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, ratio,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, ratio,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
% h6 = plot(ax1, ratio,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
% h7 = plot(ax1, ratio,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
% h8 = plot(ax1, ratio,errorTotal(:,8),legend_type_set{8},'Color',all_colors(8, :),'Display',algo_name{8});
% h9 = plot(ax1, ratio,errorTotal(:,9),legend_type_set{9},'Color',all_colors(9, :),'Display',algo_name{9});
lgd = legend(ax1, [h1 h3 h4 h5],{algo_name{1},algo_name{3},algo_name{4},algo_name{5}},'Location','southwest','Interpreter','LaTex','NumColumns',3,'Box','off');
% lgd.Position = [0.05, 0.58, 1, 0.15];
set(ax1, 'YScale', 'log', 'XLim', [.28 .72], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');
xlabel(ax1, 'Ratio');

exportgraphics(f_nmse, 's_kro_mea_nmse.pdf', 'ContentType', 'vector');


f_srr = figure('Position', figure_position);
ax2 = gca;
hold(ax2, 'on'); 

for algo_index = [1,3,4,5]
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end
    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);
    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, ratio,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [.28 .72], 'YLim', [0 1], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'Ratio', 'FontSize', fontsizeman, 'FontWeight', 'bold');

exportgraphics(f_srr, 's_kro_mea_srr.pdf', 'ContentType', 'vector');

f_time = figure('Position', figure_position);
ax3 = gca;
hold(ax3, 'on');

for algo_index = [1,3,4,5]
    % upper_bound = timeTotal(:, algo_index) + timeStd(:, algo_index);
    % lower_bound = timeTotal(:, algo_index) - timeStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(timeTotal(:, algo_index)));
    % end
    upper_bound = timeQ3(:, algo_index);
    lower_bound = timeQ1(:, algo_index);
    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    hold on
    plot(ratio,timeTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
    hold on
end
xlim([.28 .72])
grid on
set(gca, 'yscale', 'log');
f_time.Units = 'inches';
f_time.Position = [1, 1, 8, 5];
box on
set(0,'DefaultLineLineWidth',3)
set(0,'DefaultAxesFontSize',fontsizeman)
set(0,'DefaultLineMarkerSize',fontsizeman)
set(0,'DefaultAxesFontWeight','bold')
set(gca,'FontSize',fontsizeman)
set(get(gca,'Xlabel'),'FontSize',fontsizeman)
set(get(gca,'Ylabel'),'FontSize',fontsizeman)
set(get(gca,'Title'),'FontSize',fontsizeman)
set(get(gca,'Xlabel'),'FontWeight','bold')
set(get(gca,'Ylabel'),'FontWeight','bold')
set(get(gca,'Title'),'FontWeight','bold')
xlabel('Ratio')
ylabel('Time')

exportgraphics(f_time,'s_kro_mea_time.pdf','ContentType', 'vector');

%% 4: plot
clc
clear
load hie_s_varying_n.mat

all_colors = [
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-o';
line_type_set{2} = '-x';
line_type_set{3} = '->';
line_type_set{4} = '-<';
line_type_set{5} = '-^';
line_type_set{6} = '-v';
legend_type_set{1} = 'o';
legend_type_set{2} = 'x';
legend_type_set{3} = '>';
legend_type_set{4} = '<';
legend_type_set{5} = '^';
legend_type_set{6} = 'v';
algo_name{1} = 'MSSBL-Seq';
algo_name{2} = 'MSSBL-Pl';
algo_name{3} = 'MSHTP-Seq';
algo_name{4} = 'MSHTP-Pl';
algo_name{5} = 'MSIHT-Seq';
algo_name{6} = 'MSIHT-Pl';
algo_name2{1} = 'MSSBL-Seq';
algo_name2{2} = 'MSSBL';
algo_name2{3} = 'MSHTP-Seq';
algo_name2{4} = 'MSHTP';
algo_name2{5} = 'MSIHT-Seq';
algo_name2{6} = 'MSIHT';

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));


dimension = n_candidate.^I;

fontsizeman = 20;
figure_position = [100, 100, 600, 400]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse = figure('Position', figure_position);
ax1 = gca;
hold(ax1, 'on'); 

% line1 = plot(ax1, dimension,errorTotal(:,2),'-','Color',[0,0,0]);
% line2 = plot(ax1, dimension,errorTotal(:,4),'-.','Color',[0,0,0]);
for algo_index = [2,4,6]
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);
    fill_x = [dimension'; fliplr(dimension)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, dimension,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h2 = plot(ax1, dimension,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h4 = plot(ax1, dimension,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h6 = plot(ax1, dimension,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
legend(ax1, [h2 h4 h6],{algo_name{2},algo_name{4},algo_name{6}},'Location','northeast','Interpreter','LaTex','NumColumns',1,'Box','off');
grid(ax1, 'on');
set(ax1, 'YScale', 'log', 'XScale', 'log', 'YLim', [0.05 0.5]);
box(ax1, 'on');
tick_positions = 2.^(16:21);
tick_labels = {'2^{16}', '2^{17}', '2^{18}', '2^{19}', '2^{20}', '2^{21}'};
xticks(ax1, tick_positions);
xticklabels(ax1, tick_labels);
xlim(ax1, [2^(16+0.9), 2^(21-0.6)]);
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');
set(ax1,'FontSize',fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax1, 'Problem Dimension', 'FontSize', fontsizeman, 'FontWeight', 'bold');

exportgraphics(f_nmse,'dim_nmse.pdf','ContentType', 'vector');

f_time = figure('Position', figure_position);
ax2 = gca;
hold(ax2, 'on');
for algo_index = 1:6
    % upper_bound = timeTotal(:, algo_index) + timeStd(:, algo_index);
    % lower_bound = timeTotal(:, algo_index) - timeStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(timeTotal(:, algo_index)));
    % end
    upper_bound = timeQ3(:, algo_index);
    lower_bound = timeQ1(:, algo_index);
    fill_x = [dimension'; fliplr(dimension)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, dimension,timeTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h1 = plot(ax2, dimension,timeTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
h2 = plot(ax2, dimension,timeTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax2, dimension,timeTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax2, dimension,timeTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax2, dimension,timeTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
h6 = plot(ax2, dimension,timeTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
legend(ax2, [h1 h2 h3 h4 h5 h6],{algo_name{1},algo_name{2},algo_name{3},algo_name{4},algo_name{5},algo_name{6}},'Location','northwest','Interpreter','LaTex','NumColumns',3,'Box','off');
grid(ax2, 'on');
set(ax2, 'YScale', 'log', 'XScale', 'log');
box(ax2, 'on');
xticks(ax2, tick_positions);
xticklabels(ax2, tick_labels);
xlim(ax2, [2^(16+0.9), 2^(21-0.6)]);
ylim(ax2, [1e-1 .8*1e3]);
set(ax2,'FontSize',fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'Time', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax2, 'Problem Dimension', 'FontSize', fontsizeman, 'FontWeight', 'bold');

exportgraphics(f_time,'dim_time.pdf','ContentType', 'vector');
