%% 1a: plot
clc
clear
load s_sparse_snr.mat

all_colors = [
    0,      70/255, 222/255;
    0.6350, 0.0780, 0.1840;
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-*';
line_type_set{2} = '-p';
line_type_set{3} = '-o';
line_type_set{4} = '-x';
algo_name{1} = 'MSOMP';
algo_name{2} = 'KroOMP';
algo_name{3} = 'MSSBL-Seq';
algo_name{4} = 'MSSBL-Pl';

% errorTotal = squeeze(mean(error,1));
% errorStd = squeeze(std(error,0,1));
timeAVG = squeeze(mean(time,1));
% timeStd = squeeze(std(time,0,1));
% srrTotal = squeeze(mean(srr,1));
% srrStd = squeeze(std(srr,0,1));

% Central tendency: Median (50th percentile)
errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

fontsizeman = 20;
figure_position = [100, 100, 1500, 500];
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

% Figure 1: NMSE Plot (with Legend) 
f_nmse_srr = figure('Position', figure_position);
tiledlayout(1, 2, 'TileSpacing', 'compact');

ax1 = nexttile;
hold(ax1, 'on'); 
for algo_index = 1:4

    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);
    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none', 'HandleVisibility', 'off');
    plot(ax1, SNR, errorTotal(:, algo_index), line_type_set{algo_index}, ...
        'Color', all_colors(algo_index, :), 'MarkerSize', fontsizeman, 'HandleVisibility', 'off');
end
h1 = plot(ax1, NaN, NaN, '-*', 'Color', all_colors(1, :), 'MarkerSize', fontsizeman, 'LineStyle', 'none', 'DisplayName', algo_name{1});
h2 = plot(ax1, NaN, NaN, '-p', 'Color', all_colors(2, :), 'MarkerSize', fontsizeman, 'LineStyle', 'none', 'DisplayName', algo_name{2});
h3 = plot(ax1, NaN, NaN, '-o', 'Color', all_colors(3, :), 'MarkerSize', fontsizeman, 'LineStyle', 'none', 'DisplayName', algo_name{3});
h4 = plot(ax1, NaN, NaN, '-x', 'Color', all_colors(4, :), 'MarkerSize', fontsizeman, 'LineStyle', 'none', 'DisplayName', algo_name{4});
% legend(ax1, 'Location', 'northoutside', 'Orientation', 'horizontal', 'Interpreter', 'latex', 'Box', 'off');
set(ax1, 'YScale', 'log', 'XLim', [3 25], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax1, 'SNR (dB)');
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);

ax2 = nexttile;
hold(ax2, 'on');
for algo_index = 1:4

    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);

    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, SNR, srrTotal(:, algo_index), line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [3 25], 'YLim', [0 1], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax2, 'SNR (dB)');
set(0,'DefaultLineMarkerSize',fontsizeman)
grid(ax2, 'on');
box(ax2, 'on');

lgd = legend([h1 h2 h3 h4], 'Orientation', 'horizontal', 'Interpreter', 'latex', 'Box', 'off');
lgd.Position = [0.35, 0.9, 0.4, 0.15];

exportgraphics(f_nmse_srr, 's_standard_nmse_srr_app.pdf', 'ContentType', 'vector');

%% 1b: plot
clc
clear
load s_sparse_measurement.mat

all_colors = [
    0,      70/255, 222/255;
    0.6350, 0.0780, 0.1840;
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-*';
line_type_set{2} = '-p';
line_type_set{3} = '-o';
line_type_set{4} = '-x';
legend_type_set{1} = '*';
legend_type_set{2} = 'p';
legend_type_set{3} = 'o';
legend_type_set{4} = 'x';
algo_name{1} = 'MSOMP';
algo_name{2} = 'KroOMP';
algo_name{3} = 'MSSBL-Seq';
algo_name{4} = 'MSSBL-Pl';

timeAVG = squeeze(mean(time,1));

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

ratio = M_candidate.^I/Nbar;

fontsizeman = 20;
figure_position = [100, 100, 1500, 500]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse_srr = figure('Position', figure_position);
tiledlayout(1, 2, 'TileSpacing', 'compact');

ax1 = nexttile;
hold(ax1, 'on'); 
for algo_index = 1:4

    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, ratio, errorTotal(:, algo_index), line_type_set{algo_index}, 'Color', all_colors(algo_index, :));
end
h1 = plot(ax1, ratio, errorTotal(:,1), legend_type_set{1}, 'Color', all_colors(1, :), 'DisplayName', algo_name{1});
h2 = plot(ax1, ratio, errorTotal(:,2), legend_type_set{2}, 'Color', all_colors(2, :), 'DisplayName', algo_name{2});
h3 = plot(ax1, ratio, errorTotal(:,3), legend_type_set{3}, 'Color', all_colors(3, :), 'DisplayName', algo_name{3});
h4 = plot(ax1, ratio, errorTotal(:,4), legend_type_set{4}, 'Color', all_colors(4, :), 'DisplayName', algo_name{4});
% legend(ax1, [h1 h2 h3 h4], {algo_name{1},algo_name{2},algo_name{3},algo_name{4}}, 'Location','southwest', 'Interpreter','LaTex', 'Box','off');
set(ax1, 'YScale', 'log', 'XLim', [0.35 0.83], 'FontSize', fontsizeman, 'FontWeight', 'bold');
yticks([1e-5 1e-4 1e-3 1e-2 1e-1 1])
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax1, 'Ratio')
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);

ax2 = nexttile;
hold(ax2, 'on');
for algo_index = 1:4

    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, ratio, srrTotal(:, algo_index), line_type_set{algo_index}, 'Color', all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [0.35 0.83], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax2, 'Ratio')
grid(ax2, 'on');
box(ax2, 'on');

lgd = legend([h1 h2 h3 h4], 'Orientation', 'horizontal', 'Interpreter', 'latex', 'Box', 'off');
% Manually set the position: [left, bottom, width, height] in normalized units (0 to 1)
lgd.Position = [0.35, 0.9, 0.4, 0.15];

exportgraphics(f_nmse_srr, 's_standard_mea_nmse_srr_app.pdf', 'ContentType', 'vector');

%% 2a: plot
clc
clear
load hie_s_snr.mat

all_colors = [
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.6350, 0.0780, 0.1840;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-o';
line_type_set{2} = '-x';
line_type_set{3} = '-.>';
line_type_set{4} = '-.h';
line_type_set{5} = '-.<';
line_type_set{6} = '-.^';
line_type_set{7} = '-.v';
legend_type_set{1} = 'o';
legend_type_set{2} = 'x';
legend_type_set{3} = '>';
legend_type_set{4} = 'h';
legend_type_set{5} = '<';
legend_type_set{6} = '^';
legend_type_set{7} = 'v';
algo_name{1} = 'MSSBL-Seq';
algo_name{2} = 'MSSBL-Pl';
algo_name{3} = 'MSHTP-Seq';
algo_name{4} = 'HiHTP';
algo_name{5} = 'HTP';
algo_name{6} = 'MSIHT-Seq';
algo_name{7} = 'IHT';

timeAVG = squeeze(mean(time,1));

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));


timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));


srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));


fontsizeman = 20;
figure_position = [100, 100, 1500, 500];
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse_srr = figure('Position', figure_position);
tiledlayout(1, 2, 'TileSpacing', 'compact');

ax1 = nexttile;
hold(ax1, 'on'); 
line1 = plot(ax1, SNR,errorTotal(:,1),'-','Color',[0,0,0]);
line2 = plot(ax1, SNR,errorTotal(:,2),'-.','Color',[0,0,0]);
for algo_index = 1:7
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end

    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);

    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, SNR,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h1 = plot(ax1, SNR,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
h2 = plot(ax1, SNR,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, SNR,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, SNR,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, SNR,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
h6 = plot(ax1, SNR,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
h7 = plot(ax1, SNR,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
set(ax1, 'YScale', 'log', 'XLim', [3 25], 'YLim', [1e-4 1], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax1, 'SNR (dB)')
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman);

ax2 = nexttile;
hold(ax2, 'on');
for algo_index = 1:7
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end

    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);

    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, SNR,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [3 25], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'SNR (dB)', 'FontSize', fontsizeman, 'FontWeight', 'bold');

lgd = legend([h1 h2 h3 h4 h5 h6 h7 line1 line2],{algo_name{1},algo_name{2},algo_name{3},algo_name{4},algo_name{5},algo_name{6},algo_name{7},'w/o Sparsity', 'w/ Sparsity'},'Location','northoutside','Orientation','horizontal','Interpreter','LaTex','Box','off');
lgd.Position = [0.15, 0.9, 1, 0.15];

exportgraphics(f_nmse_srr, 's_hie_nmse_srr_app.pdf', 'ContentType', 'vector');

%% 2b: plot
clc
clear
load hie_s_measurement.mat

all_colors = [
    0,      0.4470, 0.7410;
    0.9290, 0.6940, 0.1250;
    1,      0,      1;
    0.6350, 0.0780, 0.1840;
    0.4900, 0.1800, 0.5600;
    0.5, 0.5, 0.5;
    0.8500, 0.3250, 0.0980
];
line_type_set{1} = '-o';
line_type_set{2} = '-x';
line_type_set{3} = '-.>';
line_type_set{4} = '-.h';
line_type_set{5} = '-.<';
line_type_set{6} = '-.^';
line_type_set{7} = '-.v';
legend_type_set{1} = 'o';
legend_type_set{2} = 'x';
legend_type_set{3} = '>';
legend_type_set{4} = 'h';
legend_type_set{5} = '<';
legend_type_set{6} = '^';
legend_type_set{7} = 'v';
algo_name{1} = 'MSSBL-Seq';
algo_name{2} = 'MSSBL-Pl';
algo_name{3} = 'MSHTP';
algo_name{4} = 'HiHTP';
algo_name{5} = 'HTP';
algo_name{6} = 'MSIHT';
algo_name{7} = 'IHT';

timeAVG = squeeze(mean(time,1));


errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

M_candidate = 48:4:72;
N = 80*ones(I,1);
Nbar = prod(N);
ratio = M_candidate.^I/Nbar;

fontsizeman = 20;
figure_position = [100, 100, 1500, 500]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse_srr = figure('Position', figure_position);
tiledlayout(1, 2, 'TileSpacing', 'compact');

ax1 = nexttile;
hold(ax1, 'on'); 
line1 = plot(ax1, ratio,errorTotal(:,1),'-','Color',[0,0,0]);
line2 = plot(ax1, ratio,errorTotal(:,2),'-.','Color',[0,0,0]);
for algo_index = 1:7
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, ratio,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h1 = plot(ax1, ratio,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
h2 = plot(ax1, ratio,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, ratio,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, ratio,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, ratio,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
h6 = plot(ax1, ratio,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
h7 = plot(ax1, ratio,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
set(ax1, 'YScale', 'log', 'XLim', [.35 .83], 'YLim', [1e-4 .5], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax1, 'Ratio', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

ax2 = nexttile;
hold(ax2, 'on');
for algo_index = 1:7
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end
    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, ratio,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [.35 .83], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'Ratio', 'FontSize', fontsizeman, 'FontWeight', 'bold');

lgd = legend([h1 h2 h3 h4 h5 h6 h7 line1 line2],{algo_name{1},algo_name{2},algo_name{3},algo_name{4},algo_name{5},algo_name{6},algo_name{7},'w/o Sparsity', 'w/ Sparsity'},'Location','northoutside','Orientation','horizontal','Interpreter','LaTex','Box','off');
lgd.Position = [0.15, 0.9, 1, 0.15];

exportgraphics(f_nmse_srr, 's_hie_mea_nmse_srr_app.pdf', 'ContentType', 'vector');


%% 3a: plot
clc
clear
load kro_sup_snr.mat

all_colors = [
    0.0000, 0.2745, 0.8706;  % Original Blue
    1.0000, 0.0000, 1.0000;  % Original Magenta
    0.0000, 0.4470, 0.7410;  % Original Sky Blue
    0.6350, 0.0780, 0.1840;  % Original Maroon
    0.9290, 0.6940, 0.1250;  % Original Yellow
    0.4900, 0.1800, 0.5600;  % Original Purple
    0.5000, 0.5000, 0.5000;  % Original Gray
    0.8500, 0.3250, 0.0980;  % Original Orange
    0.0000, 0.1880, 0.0000   % New Dark Green
];

line_type_set{1} = '-*';
line_type_set{2} = '-.>';
line_type_set{3} = '-o';
line_type_set{4} = '-s';
line_type_set{5} = '-d';
line_type_set{6} = '-.<';
line_type_set{7} = '-.^';
line_type_set{8} = '-.v';
line_type_set{9} = '-.x';

legend_type_set{1} = '*';
legend_type_set{2} = '>';
legend_type_set{3} = 'o';
legend_type_set{4} = 's';
legend_type_set{5} = 'd';
legend_type_set{6} = '<';
legend_type_set{7} = '^';
legend_type_set{8} = 'v';
legend_type_set{9} = 'x';

algo_name{1} = 'MSOMP';
algo_name{2} = 'MSHTP';
algo_name{3} = 'MSSBL';
algo_name{4} = 'SVD-KroSBL';
algo_name{5} = 'AM-KroSBL';
algo_name{6} = 'HTP';
algo_name{7} = 'MSIHT';
algo_name{8} = 'IHT';
algo_name{9} = 'KSHTP';

timeAVG = squeeze(mean(time,1));

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

fontsizeman = 20;
figure_position = [100, 100, 1500, 500]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse_srr = figure('Position', figure_position);
tiledlayout(1, 2, 'TileSpacing', 'compact');

ax1 = nexttile;
hold(ax1, 'on'); 
line1 = plot(ax1, SNR,errorTotal(:,1),'-','Color',[0,0,0]);
line2 = plot(ax1, SNR,errorTotal(:,2),'-.','Color',[0,0,0]);
h10 = plot(ax1, SNR,errorTotal(:,7),'-','Color',[1 1 1]);
h11 = plot(ax1, SNR,errorTotal(:,8),'-.','Color',[1 1 1]);
for algo_index = 1:9
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);

    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, SNR,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h1 = plot(ax1, SNR,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
h2 = plot(ax1, SNR,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, SNR,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, SNR,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, SNR,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
h6 = plot(ax1, SNR,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
h7 = plot(ax1, SNR,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
h8 = plot(ax1, SNR,errorTotal(:,8),legend_type_set{8},'Color',all_colors(8, :),'Display',algo_name{8});
h9 = plot(ax1, SNR,errorTotal(:,9),legend_type_set{9},'Color',all_colors(9, :),'Display',algo_name{9});
set(ax1, 'YScale', 'log', 'XLim', [3 25], 'YLim', [1e-5 1e4], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax1, 'SNR (dB)', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

ax2 = nexttile;
hold(ax2, 'on');
for algo_index = 1:9
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end
    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);

    fill_x = [SNR'; fliplr(SNR)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, SNR,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [3 25], 'YLim', [0 1], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'SNR (dB)', 'FontSize', fontsizeman, 'FontWeight', 'bold');


lgd = legend(ax1, [h1 h2 h3 h6 h5 h4 h7 h8 h9 line1 line2],...
    {algo_name{1},algo_name{2},algo_name{3},algo_name{6},...
     algo_name{5},algo_name{4},algo_name{7},algo_name{8},...
     algo_name{9},'w/o Sparsity', 'w/ Sparsity'},...
    'Interpreter','LaTex','Box','off','Location','northoutside','Orientation','horizontal');
lgd.Position = [0.075, 0.9, 1, 0.15];

exportgraphics(f_nmse_srr, 's_kro_nmse_srr_app.pdf', 'ContentType', 'vector');


%% 3b: plot
clc
clear
load kro_sup_measurement.mat

M_candidate = 12:1:16;
ratio = M_candidate.^I/Nbar;
all_colors = [
    0.0000, 0.2745, 0.8706;  % Original Blue
    1.0000, 0.0000, 1.0000;  % Original Magenta
    0.0000, 0.4470, 0.7410;  % Original Sky Blue
    0.6350, 0.0780, 0.1840;  % Original Maroon
    0.9290, 0.6940, 0.1250;  % Original Yellow
    0.4900, 0.1800, 0.5600;  % Original Purple
    0.5000, 0.5000, 0.5000;  % Original Gray
    0.8500, 0.3250, 0.0980;  % Original Orange
    0.0000, 0.1880, 0.0000   % New Dark Green
];

line_type_set{1} = '-*';
line_type_set{2} = '-.>';
line_type_set{3} = '-o';
line_type_set{4} = '-s';
line_type_set{5} = '-d';
line_type_set{6} = '-.<';
line_type_set{7} = '-.^';
line_type_set{8} = '-.v';
line_type_set{9} = '-.x';

legend_type_set{1} = '*';
legend_type_set{2} = '>';
legend_type_set{3} = 'o';
legend_type_set{4} = 's';
legend_type_set{5} = 'd';
legend_type_set{6} = '<';
legend_type_set{7} = '^';
legend_type_set{8} = 'v';
legend_type_set{9} = 'x';

algo_name{1} = 'MSOMP';
algo_name{2} = 'MSHTP';
algo_name{3} = 'MSSBL';
algo_name{4} = 'SVD-KroSBL';
algo_name{5} = 'AM-KroSBL';
algo_name{6} = 'HTP';
algo_name{7} = 'MSIHT';
algo_name{8} = 'IHT';
algo_name{9} = 'KSHTP';

timeAVG = squeeze(mean(time,1));

errorTotal = squeeze(median(error, 1));
errorQ1 = squeeze(quantile(error, 0.25, 1));
errorQ3 = squeeze(quantile(error, 0.75, 1));

timeTotal = squeeze(median(time, 1));
timeQ1 = squeeze(quantile(time, 0.25, 1));
timeQ3 = squeeze(quantile(time, 0.75, 1));

srrTotal = squeeze(median(srr, 1));
srrQ1 = squeeze(quantile(srr, 0.25, 1));
srrQ3 = squeeze(quantile(srr, 0.75, 1));

fontsizeman = 20;
figure_position = [100, 100, 1500, 500]; 
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultLineMarkerSize',fontsizeman); 
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

f_nmse_srr = figure('Position', figure_position);
tiledlayout(1, 2, 'TileSpacing', 'compact');

ax1 = nexttile;
hold(ax1, 'on'); 
line1 = plot(ax1, ratio,errorTotal(:,1),'-','Color',[0,0,0]);
line2 = plot(ax1, ratio,errorTotal(:,2),'-.','Color',[0,0,0]);
for algo_index = 1:9
    % upper_bound = errorTotal(:, algo_index) + errorStd(:, algo_index);
    % lower_bound = errorTotal(:, algo_index) - errorStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(errorTotal(:, algo_index)));
    % end
    upper_bound = errorQ3(:, algo_index);
    lower_bound = errorQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax1, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax1, ratio,errorTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
h1 = plot(ax1, ratio,errorTotal(:,1),legend_type_set{1},'Color',all_colors(1, :),'Display',algo_name{1});
h2 = plot(ax1, ratio,errorTotal(:,2),legend_type_set{2},'Color',all_colors(2, :),'Display',algo_name{2});
h3 = plot(ax1, ratio,errorTotal(:,3),legend_type_set{3},'Color',all_colors(3, :),'Display',algo_name{3});
h4 = plot(ax1, ratio,errorTotal(:,4),legend_type_set{4},'Color',all_colors(4, :),'Display',algo_name{4});
h5 = plot(ax1, ratio,errorTotal(:,5),legend_type_set{5},'Color',all_colors(5, :),'Display',algo_name{5});
h6 = plot(ax1, ratio,errorTotal(:,6),legend_type_set{6},'Color',all_colors(6, :),'Display',algo_name{6});
h7 = plot(ax1, ratio,errorTotal(:,7),legend_type_set{7},'Color',all_colors(7, :),'Display',algo_name{7});
h8 = plot(ax1, ratio,errorTotal(:,8),legend_type_set{8},'Color',all_colors(8, :),'Display',algo_name{8});
h9 = plot(ax1, ratio,errorTotal(:,9),legend_type_set{9},'Color',all_colors(9, :),'Display',algo_name{9});
set(ax1, 'YScale', 'log', 'XLim', [.28 .72], 'YLim', [1e-4 1e0], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax1, 'NSE', 'FontSize', fontsizeman, 'FontWeight', 'bold');
xlabel(ax1, 'Ratio', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax1, 'on');
box(ax1, 'on');
set(0,'DefaultLineLineWidth',3);
set(0,'DefaultAxesFontSize',fontsizeman);
set(0,'DefaultLineMarkerSize',fontsizeman);
set(0,'DefaultAxesFontWeight','bold');

ax2 = nexttile;
hold(ax2, 'on');
for algo_index = 1:9
    % upper_bound = srrTotal(:, algo_index) + srrStd(:, algo_index);
    % lower_bound = srrTotal(:, algo_index) - srrStd(:, algo_index);
    % if min(lower_bound) < 0
    %     lower_bound = max(lower_bound, min(srrTotal(:, algo_index)));
    % end
    upper_bound = srrQ3(:, algo_index);
    lower_bound = srrQ1(:, algo_index);

    fill_x = [ratio'; fliplr(ratio)']';
    fill_y = [lower_bound; fliplr(upper_bound')']';
    fill(ax2, fill_x, fill_y, all_colors(algo_index, :), 'FaceAlpha', 0.15, 'EdgeColor', 'none');
    plot(ax2, ratio,srrTotal(:,algo_index),line_type_set{algo_index},'Color',all_colors(algo_index, :));
end
hold(ax2, 'off');
set(ax2, 'XLim', [.28 .72], 'YLim', [0 1], 'FontSize', fontsizeman, 'FontWeight', 'bold');
ylabel(ax2, 'SRR', 'FontSize', fontsizeman, 'FontWeight', 'bold');
grid(ax2, 'on');
box(ax2, 'on');
xlabel(ax2, 'Ratio', 'FontSize', fontsizeman, 'FontWeight', 'bold');

lgd = legend([h1 h2 h3 h6 h5 h4 h7 h8 h9 line1 line2],{algo_name{1},algo_name{2},algo_name{3},algo_name{6},algo_name{5},algo_name{4},algo_name{7},algo_name{8},algo_name{9},'w/o Sparsity', 'w/ Sparsity'},'Location','southwest','Interpreter','LaTex','Box','off','Location','northoutside','Orientation','horizontal');
lgd.Position = [0.075, 0.9, 1, 0.15];

exportgraphics(f_nmse_srr, 's_kro_mea_nmse_srr_app.pdf', 'ContentType', 'vector');