# results/ablation_sample.jsonl — field meanings

seed: int; experiment seed
spec: object; minimal run spec:
  - estimator: string key (see ESTIMATOR_GLOSSARY.md)
  - oracle_coverage: fraction in [0,1]
  - sample_size: intended n (pre-filter)
  - extra: {use_weight_calibration: bool, reward_calibration_mode: "auto"|"monotone", var_cap: float}
success: bool; run completed without gating
estimates: {policy -> scalar}; KPI in the paper's units/orientation
se_if: {policy -> float}; influence-function (main) SE
se_robust: {policy -> float}; OUA-jackknife robust SE (accounts for calibration uncertainty)
ci95: {policy -> [lo, hi]}; 95% Wald interval using se_if
ci95_robust: {policy -> [lo, hi]}; 95% Wald interval using se_robust
n_samples: int; rows used after TF/filters
n_oracle: int; rows with oracle label (≈ oracle_coverage × n_samples)
ess_relative: {policy -> float}; ESS/n ratio (1.0 = no variance, <0.1 = high variance)
max_weight: {policy -> float}; maximum normalized weight
weight_cv: {policy -> float}; coefficient of variation of weights
calibration_r2: float|null; R² of judge→oracle isotonic fit (null at 100% oracle)
outcome_r2: {policy -> float}; R² of outcome model g(X,A) (DR estimators only)
tail_alpha: {policy -> float}; tail index from Hill estimator (>2 = finite variance)