# English words for split induction
def get_splittable_words(models, n_tokens=1000):
    from english_words import english_words_lower_alpha_set as english_words
    words = []
    for w in list(english_words):
        good = True
        for m in models:
            if len(m.tokenizer.encode(w)) != 2:
                good = False
            if len(m.tokenizer.encode(' '+w)) != 1:
                good = False
        
        if good:
            words.append(w)
        if len(words) >= n_tokens:
            break
    return words

variable_names = "data name file value test new result line user key default request path output node item url model response text version function log string field start number values sub index error current context image message check json create size event state row obj parser end files form query fields instance label run action target array code num table source msg config first required options ret update module status group content client filename results last read command val base format color settings order found count match tag title parent call session token server host date description mode expected project info valid page header option task shape load names port old resource root".split(" ")
# Removed logging, logger verbose since they are 2 tokens in GPT2 tokenizer

#COMMON_NOUNS = common_nouns =  common_single_token_nouns = ['price', 'control', 'action', 'cost', 'issue', 'process', 'position', 'course', 'minute', 'education', 'type', 'research', 'subject', 'girl', 'moment', 'age', 'father', 'force', 'order', 'value', 'act', 'matter', 'health', 'lot', 'decision', 'street', 'patient', 'class', 'mind', 'church', 'condition', 'paper', 'bank', 'century', 'section', 'activity', 'hundred', 'table', 'death', 'building', 'sense', 'sort', 'staff', 'team', 'experience', 'student', 'language', 'town', 'plan', 'management', 'morning', 'committee', 'product', 'practice', 'evidence', 'ground', 'letter', 'foot', 'boy', 'back', 'game', 'food', 'union', 'role', 'event', 'land', 'art', 'support', 'range', 'stage', 'trade', 'voice', 'arm', 'club', 'field', 'history', 'parent', 'account', 'material', 'care', 'manager', 'project', 'record', 'example', 'training', 'window', 'air', 'difference', 'light', 'wife', 'relationship', 'quality', 'rule', 'pound', 'story', 'tax', 'worker', 'data', 'model', 'nature', 'structure', 'bed', 'hospital', 'method', 'unit', 'detail', 'date', 'wall', 'computer', 'amount', 'bit', 'president', 'scheme', 'chapter', 'theory', 'property', 'son', 'director', 'leader', 'south', 'application', 'firm', 'board', 'king', 'production', 'operation', 'share', 'agreement', 'lord', 'contract', 'picture', 'test', 'security', 'election', 'source', 'colour', 'future', 'site', 'loss', 'shop', 'animal', 'heart', 'purpose', 'standard', 'page', 'doctor', 'factor', 'hair', 'love', 'music', 'charge', 'pattern', 'design', 'piece', 'population', 'tree', 'knowledge', 'performance', 'plant', 'pressure', 'fire', 'environment', 'size', 'analysis', 'rest', 'success', 'thought', 'region', 'attention', 'list', 'relation', 'set', 'space', 'statement', 'demand', 'sea', 'step', 'capital', 'choice', 'player', 'station', 'film', 'attempt', 'feature', 'income', 'individual', 'cup', 'technology', 'machine', 'cell', 'degree', 'energy', 'growth', 'treatment', 'mile', 'function', 'risk', 'sound', 'task', 'top', 'resource', 'floor', 'science', 'style', 'hall', 'horse', 'response', 'character', 'user', 'answer', 'dog', 'look', 'brother', 'argument', 'season', 'bill', 'element', 'glass', 'duty', 'claim', 'fund', 'leg', 'park', 'title', 'note', 'discussion', 'summer', 'daughter', 'sun', 'box', 'customer', 'river', 'profit', 'division', 'measure', 'stone', 'post', 'procedure', 'client', 'help', 'image', 'oil', 'sector', 'attack', 'direction', 'seat', 'employment', 'goal', 'appeal', 'sign', 'ability', 'campaign', 'fish', 'item', 'medium', 'show', 'version', 'drug', 'library', 'press', 'visit', 'surface', 'blood', 'culture', 'memory', 'return', 'bar', 'talk', 'access', 'deal', 'star', 'text', 'cause', 'mouth', 'payment', 'context', 'reference', 'second', 'article', 'chair', 'earth', 'object', 'agency', 'card', 'collection', 'communication', 'public', 'document', 'solution', 'weight', 'bird', 'district', 'opinion', 'organization', 'rock', 'call', 'edge', 'exchange', 'miss', 'option', 'quarter', 'stock', 'whole', 'aid', 'concept', 'match', 'network', 'radio', 'target', 'corner', 'finger', 'forest', 'race', 'sex', 'ball', 'crime', 'employee', 'message', 'peace', 'review', 'scale', 'scene', 'speech', 'band', 'expression', 'failure', 'hill', 'reader', 'owner', 'trust', 'truth', 'turn', 'file', 'past', 'sentence', 'start', 'trial', 'balance', 'branch', 'copy', 'league', 'length', 'wind', 'front', 'move', 'pain', 'spirit', 'train', 'contact', 'official', 'strength', 'cash', 'gas', 'shape', 'transport', 'agent', 'pair', 'protection', 'rise', 'driver', 'hope', 'master', 'meaning', 'vote', 'adult', 'exercise', 'play', 'fig', 'proportion', 'route', 'speed', 'credit', 'impact', 'danger', 'flower', 'half', 'path', 'reaction', 'track', 'video', 'aim', 'bag', 'belief', 'comment', 'content', 'distance', 'gold', 'link', 'skin', 'boat', 'dad', 'prison', 'sight', 'wine', 'debt', 'offer', 'vehicle', 'writer', 'hole', 'injury', 'package', 'confidence', 'generation', 'key', 'phone', 'sample', 'judge', 'ship', 'threat', 'volume', 'administration', 'author', 'background', 'engine', 'entry', 'introduction', 'stuff', 'yard', 'bus', 'regulation', 'row', 'song', 'category', 'consumer', 'football', 'meal', 'tour', 'wood', 'bridge', 'construction', 'contrast', 'description', 'distribution', 'existence', 'flat', 'lip', 'session', 'sheet', 'code', 'loan', 'asset', 'flight', 'limit', 'plate', 'rain', 'respect', 'writing', 'capacity', 'challenge', 'dream', 'factory', 'selection', 'spring', 'while', 'definition', 'egg', 'examination', 'mark', 'notice', 'output', 'reduction', 'will', 'address', 'bottom', 'kid', 'middle', 'neck', 'run', 'acid', 'assembly', 'birth', 'ear', 'error', 'instruction', 'module', 'store', 'transfer', 'wave', 'channel', 'component', 'cut', 'fee', 'grant', 'lead', 'temperature', 'weather', 'block', 'brain', 'guide', 'program', 'screen', 'connection', 'cover', 'map', 'metal', 'noise', 'phase', 'pool', 'search', 'sequence', 'sky', 'sum', 'trip', 'cat', 'display', 'gallery', 'gate', 'gun', 'heat', 'location', 'reading', 'theme', 'drive', 'faith', 'hell', 'learning', 'opening', 'priority', 'spot', 'tool', 'castle', 'coal', 'corp', 'flow', 'lane', 'motion', 'release', 'total', 'wing', 'border', 'index', 'pocket', 'ring', 'billion', 'device', 'engineering', 'fruit', 'lake', 'leaf', 'pub', 'representation', 'request', 'square', 'tone', 'walk', 'chain', 'circle', 'creation', 'fall', 'present', 'shot', 'defendant', 'fashion', 'god', 'mass', 'panel', 'fan', 'iron', 'motor', 'nose', 'origin', 'potential', 'ticket', 'bone', 'cancer', 'chief', 'editor', 'fuel', 'general', 'height', 'round', 'vision', 'warning', 'being', 'comparison', 'cross', 'living', 'rail', 'signal', 'working', 'column', 'complaint', 'finding', 'gap', 'grass', 'plane', 'plastic', 'root', 'score', 'shadow', 'shock', 'territory', 'touch', 'boundary', 'database', 'exception', 'formation', 'identity', 'male', 'ref', 'resident', 'resolution', 'topic', 'transaction', 'break', 'camp', 'currency', 'fault', 'phrase', 'quantity', 'thinking', 'coat', 'extension', 'gene', 'mill', 'stress', 'boot', 'command', 'depth', 'female', 'frame', 'framework', 'holder', 'ice', 'inch', 'port', 'protein', 'rose', 'saving', 'string', 'wheel', 'bishop', 'cycle', 'export', 'hat', 'load', 'mode', 'setting', 'stairs', 'travel', 'average', 'camera', 'focus', 'green', 'guard', 'input', 'layer', 'plaintiff', 'poll', 'sleep', 'suit', 'bread', 'cake', 'efficiency', 'judgment', 'peak', 'presentation', 'resistance', 'self', 'angle', 'bay', 'bid', 'cloud', 'custom', 'dollar', 'ratio', 'variable', 'zone', 'actor', 'bond', 'chip', 'core', 'final', 'frequency', 'gain', 'guy', 'intervention', 'relative', 'rent', 'reply', 'secret', 'shirt', 'apple', 'discovery', 'equation', 'instance', 'intelligence', 'lad', 'pipe', 'anger', 'curve', 'disk', 'fight', 'hearing', 'hero', 'infection', 'journal', 'left', 'mail', 'pace', 'paragraph', 'permission', 'platform', 'print', 'rank', 'sand', 'scope', 'shift', 'stream', 'witness', 'chemical', 'circuit', 'clock', 'delay', 'host', 'human', 'salt', 'count', 'formula', 'mission', 'pack', 'remark', 'seed', 'tail', 'tie', 'watch', 'dark', 'hold', 'mine', 'net', 'observer', 'pitch', 'symbol', 'tip', 'dimension', 'implementation', 'interval', 'operator', 'professional', 'schedule', 'shell', 'storage', 'summary', 'tube', 'conduct', 'determination', 'drop', 'fabric', 'import', 'label', 'percent', 'pot', 'proof', 'strain', 'unity', 'win', 'wire', 'addition', 'bell', 'comfort', 'complex', 'conviction', 'draft', 'grade', 'lift', 'mouse', 'movie', 'profile', 'standing', 'surgery', 'belt', 'black', 'check', 'composition', 'joy', 'local', 'pit', 'red', 'register', 'storm', 'transition', 'album', 'ban', 'bench', 'button', 'cap', 'chart', 'coin', 'constraint', 'dust', 'fellow', 'folk', 'margin', 'pole', 'stand', 'stick', 'tin']
#Version below is GPT-ready
COMMON_NOUNS = common_nouns =  common_single_token_nouns = ['price', 'control', 'action', 'cost', 'issue', 'process', 'position', 'course', 'minute', 'education', 'type', 'research', 'subject', 'girl', 'age', 'father', 'force', 'order', 'value', 'act', 'matter', 'health', 'lot', 'street', 'patient', 'class', 'mind', 'church', 'condition', 'paper', 'bank', 'century', 'section', 'activity', 'table', 'building', 'sense', 'sort', 'staff', 'team', 'student', 'language', 'town', 'plan', 'management', 'morning', 'committee', 'product', 'practice', 'evidence', 'ground', 'letter', 'foot', 'boy', 'back', 'game', 'food', 'union', 'role', 'event', 'land', 'art', 'support', 'range', 'stage', 'trade', 'voice', 'arm', 'club', 'field', 'history', 'parent', 'account', 'material', 'care', 'manager', 'project', 'record', 'example', 'training', 'window', 'air', 'light', 'wife', 'quality', 'rule', 'pound', 'story', 'tax', 'worker', 'data', 'model', 'nature', 'bed', 'hospital', 'method', 'unit', 'detail', 'date', 'wall', 'computer', 'amount', 'bit', 'president', 'chapter', 'property', 'son', 'director', 'leader', 'south', 'application', 'board', 'king', 'production', 'operation', 'share', 'lord', 'contract', 'picture', 'test', 'security', 'election', 'source', 'colour', 'future', 'site', 'loss', 'shop', 'animal', 'heart', 'purpose', 'standard', 'page', 'doctor', 'factor', 'hair', 'love', 'music', 'charge', 'pattern', 'design', 'piece', 'population', 'tree', 'knowledge', 'performance', 'plant', 'pressure', 'fire', 'environment', 'size', 'analysis', 'rest', 'success', 'thought', 'region', 'list', 'relation', 'set', 'space', 'statement', 'demand', 'sea', 'step', 'capital', 'choice', 'player', 'station', 'film', 'feature', 'income', 'individual', 'cup', 'technology', 'machine', 'cell', 'degree', 'energy', 'growth', 'treatment', 'mile', 'function', 'risk', 'sound', 'task', 'top', 'resource', 'floor', 'science', 'style', 'hall', 'horse', 'response', 'character', 'user', 'answer', 'dog', 'look', 'brother', 'argument', 'season', 'bill', 'element', 'glass', 'duty', 'claim', 'fund', 'leg', 'park', 'title', 'note', 'daughter', 'sun', 'box', 'river', 'profit', 'division', 'stone', 'post', 'client', 'help', 'image', 'oil', 'sector', 'attack', 'direction', 'seat', 'employment', 'goal', 'sign', 'ability', 'campaign', 'fish', 'item', 'medium', 'show', 'version', 'drug', 'library', 'press', 'surface', 'blood', 'culture', 'memory', 'return', 'bar', 'talk', 'access', 'deal', 'star', 'text', 'cause', 'mouth', 'payment', 'context', 'reference', 'second', 'article', 'chair', 'earth', 'object', 'agency', 'card', 'collection', 'communication', 'public', 'document', 'weight', 'bird', 'rock', 'call', 'edge', 'miss', 'option', 'quarter', 'stock', 'aid', 'concept', 'match', 'network', 'radio', 'target', 'finger', 'forest', 'race', 'sex', 'ball', 'crime', 'message', 'peace', 'review', 'scale', 'scene', 'speech', 'band', 'expression', 'hill', 'reader', 'owner', 'trust', 'truth', 'turn', 'file', 'past', 'start', 'trial', 'balance', 'copy', 'league', 'length', 'wind', 'front', 'move', 'pain', 'spirit', 'train', 'contact', 'official', 'strength', 'cash', 'gas', 'shape', 'agent', 'pair', 'protection', 'rise', 'driver', 'master', 'meaning', 'vote', 'adult', 'play', 'fig', 'route', 'speed', 'credit', 'impact', 'danger', 'flower', 'half', 'path', 'track', 'video', 'aim', 'bag', 'comment', 'content', 'distance', 'gold', 'link', 'skin', 'boat', 'dad', 'prison', 'sight', 'wine', 'offer', 'writer', 'hole', 'package', 'confidence', 'generation', 'key', 'phone', 'sample', 'ship', 'threat', 'volume', 'author', 'background', 'engine', 'entry', 'stuff', 'yard', 'bus', 'regulation', 'row', 'song', 'category', 'consumer', 'football', 'meal', 'wood', 'bridge', 'description', 'existence', 'flat', 'lip', 'session', 'sheet', 'code', 'flight', 'limit', 'plate', 'rain', 'respect', 'writing', 'capacity', 'dream', 'selection', 'spring', 'while', 'definition', 'egg', 'examination', 'mark', 'notice', 'output', 'will', 'address', 'bottom', 'kid', 'middle', 'neck', 'run', 'acid', 'assembly', 'birth', 'ear', 'error', 'module', 'store', 'transfer', 'wave', 'channel', 'component', 'cut', 'fee', 'lead', 'weather', 'block', 'brain', 'guide', 'program', 'screen', 'connection', 'cover', 'map', 'metal', 'phase', 'pool', 'search', 'sequence', 'sky', 'sum', 'trip', 'cat', 'display', 'gallery', 'gate', 'heat', 'location', 'reading', 'theme', 'drive', 'faith', 'hell', 'learning', 'opening', 'priority', 'spot', 'tool', 'castle', 'coal', 'flow', 'lane', 'motion', 'release', 'total', 'wing', 'border', 'index', 'pocket', 'ring', 'billion', 'device', 'engineering', 'fruit', 'lake', 'leaf', 'pub', 'request', 'square', 'tone', 'walk', 'chain', 'circle', 'creation', 'fall', 'present', 'shot', 'fashion', 'god', 'mass', 'panel', 'fan', 'iron', 'origin', 'ticket', 'bone', 'cancer', 'chief', 'editor', 'fuel', 'general', 'height', 'round', 'vision', 'warning', 'being', 'cross', 'living', 'rail', 'working', 'column', 'finding', 'gap', 'grass', 'plane', 'root', 'score', 'shadow', 'shock', 'touch', 'database', 'formation', 'male', 'ref', 'resident', 'resolution', 'topic', 'break', 'camp', 'currency', 'phrase', 'thinking', 'coat', 'mill', 'stress', 'boot', 'command', 'depth', 'female', 'frame', 'framework', 'holder', 'ice', 'inch', 'port', 'protein', 'rose', 'saving', 'string', 'wheel', 'bishop', 'cycle', 'export', 'hat', 'load', 'mode', 'setting', 'stairs', 'travel', 'average', 'camera', 'focus', 'green', 'guard', 'input', 'layer', 'poll', 'sleep', 'suit', 'bread', 'cake', 'efficiency', 'peak', 'self', 'angle', 'bay', 'bid', 'cloud', 'custom', 'dollar', 'variable', 'zone', 'actor', 'chip', 'core', 'final', 'frequency', 'gain', 'guy', 'relative', 'rent', 'reply', 'secret', 'shirt', 'apple', 'instance', 'intelligence', 'lad', 'pipe', 'anger', 'disk', 'fight', 'hero', 'journal', 'left', 'mail', 'pace', 'paragraph', 'platform', 'print', 'rank', 'sand', 'scope', 'shift', 'stream', 'chemical', 'clock', 'delay', 'host', 'human', 'count', 'mission', 'pack', 'seed', 'tail', 'tie', 'watch', 'dark', 'hold', 'mine', 'net', 'tip', 'dimension', 'operator', 'professional', 'shell', 'storage', 'summary', 'tube', 'conduct', 'determination', 'drop', 'import', 'label', 'percent', 'pot', 'proof', 'unity', 'win', 'wire', 'bell', 'comfort', 'complex', 'draft', 'grade', 'lift', 'mouse', 'movie', 'profile', 'standing', 'belt', 'black', 'check', 'joy', 'local', 'pit', 'red', 'register', 'storm', 'album', 'ban', 'bench', 'button', 'cap', 'chart', 'coin', 'dust', 'folk', 'margin', 'pole', 'stand', 'stick', 'tin']

#common_words = ["the", "of", "to", "and", "a", "in", "is", "it", "you", "that", "he", "was", "for", "on", "are", "with", "as", "I", "his", "they", "be", "at", "one", "have", "this", "from", "or", "had", "by", "not", "word", "but", "what", "some", "we", "can", "out", "other", "were", "all", "there", "when", "up", "use", "your", "how", "said", "an", "each", "she", "which", "do", "their", "time", "if", "will", "way", "about", "many", "then", "them", "write", "would", "like", "so", "these", "her", "long", "make", "thing", "see", "him", "two", "has", "look", "more", "day", "could", "go", "come", "did", "number", "sound", "no", "most", "people", "my", "over", "know", "water", "than", "call", "first", "who", "may", "down", "side", "been", "now", "find", "any", "new", "work", "part", "take", "get", "place", "made", "live", "where", "after", "back", "little", "only", "round", "man", "year", "came", "show", "every", "good", "me", "give", "our", "under", "name", "very", "through", "just", "form", "sentence", "great", "think", "say", "help", "low", "line", "differ", "turn", "cause", "much", "mean", "before", "move", "right", "boy", "old", "too", "same", "tell", "does", "set", "three", "want", "air", "well", "also", "play", "small", "end", "put", "home", "read", "hand", "port", "large", "spell", "add", "even", "land", "here", "must", "big", "high", "such", "follow", "act", "why", "ask", "men", "change", "went", "light", "kind", "off", "need", "house", "picture", "try", "us", "again", "animal", "point", "mother", "world", "near", "build", "self", "earth", "father", "head", "stand", "own", "page", "should", "country", "found", "answer", "school", "grow", "study", "still", "learn", "plant", "cover", "food", "sun", "four", "between", "state", "keep", "eye", "never", "last", "let", "thought", "city", "tree", "cross", "farm", "hard", "start", "might", "story", "saw", "far", "sea", "draw", "left", "late", "run", "while", "press", "close", "night", "real", "life", "few", "north", "open", "seem", "together", "next", "white", "children", "begin", "got", "walk", "example", "ease", "paper", "group", "always", "music", "those", "both", "mark", "often", "letter", "until", "mile", "river", "car", "feet", "care", "second", "book", "carry", "took", "science", "eat", "room", "friend", "began", "idea", "fish", "mountain", "stop", "once", "base", "hear", "horse", "cut", "sure", "watch", "color", "face", "wood", "main", "enough", "plain", "girl", "usual", "young", "ready", "above", "ever", "red", "list", "though", "feel", "talk", "bird", "soon", "body", "dog", "family", "direct", "pose", "leave", "song", "measure", "door", "product", "black", "short", "numeral", "class", "wind", "question", "happen", "complete", "ship", "area", "half", "rock", "order", "fire", "south", "problem", "piece", "told", "knew", "pass", "since", "top", "whole", "king", "space", "heard", "best", "hour", "better", "true", "during", "hundred", "five", "remember", "step", "early", "hold", "west", "ground", "interest", "reach", "fast", "verb", "sing", "listen", "six", "table", "travel", "less", "morning", "ten", "simple", "several", "vowel", "toward", "war", "lay", "against", "pattern", "slow", "center", "love", "person", "money", "serve", "appear", "road", "map", "rain", "rule", "govern", "pull", "cold", "notice", "voice", "unit", "power", "town", "fine", "certain", "fly", "fall", "lead", "cry", "dark", "machine", "note", "wait", "plan", "figure", "star", "box", "noun", "field", "rest", "correct", "able", "pound", "done", "beauty", "drive", "stood", "contain", "front", "teach", "week", "final", "gave", "green", "oh", "quick", "develop", "ocean", "warm", "free", "minute", "strong", "special", "mind", "behind", "clear", "tail", "produce", "fact", "street", "inch", "multiply", "nothing", "course", "stay", "wheel", "full", "force", "blue", "object", "decide", "surface", "deep", "moon", "island", "foot", "system", "busy", "test", "record", "boat", "common", "gold", "possible", "plane", "stead", "dry", "wonder", "laugh", "thousand", "ago", "ran", "check", "game", "shape", "equate", "hot", "miss", "brought", "heat", "snow", "tire", "bring", "yes", "distant", "fill", "east", "paint", "language", "among", "grand", "ball", "yet", "wave", "drop", "heart", "am", "present", "heavy", "dance", "engine", "position", "arm", "wide", "sail", "material", "size", "vary", "settle", "speak", "weight", "general", "ice", "matter", "circle", "pair", "include", "divide", "syllable", "felt", "perhaps", "pick", "sudden", "count", "square", "reason", "length", "represent", "art", "subject", "region", "energy", "hunt", "probable", "bed", "brother", "egg", "ride", "cell", "believe", "fraction", "forest", "sit", "race", "window", "store", "summer", "train", "sleep", "prove", "lone", "leg", "exercise", "wall", "catch", "mount", "wish", "sky", "board", "joy", "winter", "sat", "written", "wild", "instrument", "kept", "glass", "grass", "cow", "job", "edge", "sign", "visit", "past", "soft", "fun", "bright", "gas", "weather", "month", "million", "bear", "finish", "happy", "hope", "flower", "clothe", "strange", "gone", "jump", "baby", "eight", "village", "meet", "root", "buy", "raise", "solve", "metal", "whether", "push", "seven", "paragraph", "third", "shall", "held", "hair", "describe", "cook", "floor", "either", "result", "burn", "hill", "safe", "cat", "century", "consider", "type", "law", "bit", "coast", "copy", "phrase", "silent", "tall", "sand", "soil", "roll", "temperature", "finger", "industry", "value", "fight", "lie", "beat", "excite", "natural", "view", "sense", "ear", "else", "quite", "broke", "case", "middle", "kill", "son", "lake", "moment", "scale", "loud", "spring", "observe", "child", "straight", "consonant", "nation", "dictionary", "milk", "speed", "method", "organ", "pay", "age", "section", "dress", "cloud", "surprise", "quiet", "stone", "tiny", "climb", "cool", "design", "poor", "lot", "experiment", "bottom", "key", "iron", "single", "stick", "flat", "twenty", "skin", "smile", "crease", "hole", "trade", "melody", "trip", "office", "receive", "row", "mouth", "exact", "symbol", "die", "least", "trouble", "shout", "except", "wrote", "seed", "tone", "join", "suggest", "clean", "break", "lady", "yard", "rise", "bad", "blow", "oil", "blood", "touch", "grew", "cent", "mix", "team", "wire", "cost", "lost", "brown", "wear", "garden", "equal", "sent", "choose", "fell", "fit", "flow", "fair", "bank", "collect", "save", "control", "decimal", "gentle", "woman", "captain", "practice", "separate", "difficult", "doctor", "please", "protect", "noon", "whose", "locate", "ring", "character", "insect", "caught", "period", "indicate", "radio", "spoke", "atom", "human", "history", "effect", "electric", "expect", "crop", "modern", "element", "hit", "student", "corner", "party", "supply", "bone", "rail", "imagine", "provide", "agree", "thus", "capital", "chair", "danger", "fruit", "rich", "thick", "soldier", "process", "operate", "guess", "necessary", "sharp", "wing", "create", "neighbor", "wash", "bat", "rather", "crowd", "corn", "compare", "poem", "string", "bell", "depend", "meat", "rub", "tube", "famous", "dollar", "stream", "fear", "sight", "thin", "triangle", "planet", "hurry", "chief", "colony", "clock", "mine", "tie", "enter", "major", "fresh", "search", "send", "yellow", "gun", "allow", "print", "dead", "spot", "desert", "suit", "current", "lift", "rose", "continue", "block", "chart", "hat", "sell", "success", "company", "subtract", "event", "particular", "deal", "swim", "term", "opposite", "wife", "shoe", "shoulder", "spread", "arrange", "camp", "invent", "cotton", "born", "determine", "quart", "nine", "truck", "noise", "level", "chance", "gather", "shop", "stretch", "throw", "shine", "property", "column", "molecule", "select", "wrong", "gray", "repeat", "require", "broad", "prepare", "salt", "nose", "plural", "anger", "claim", "continent", "oxygen", "sugar", "death", "pretty", "skill", "women", "season", "solution", "magnet", "silver", "thank", "branch", "match", "suffix", "especially", "fig", "afraid", "huge", "sister", "steel", "discuss", "forward", "similar", "guide", "experience", "score", "apple", "bought", "led", "pitch", "coat", "mass", "card", "band", "rope", "slip", "win", "dream", "evening", "condition", "feed", "tool", "total", "basic", "smell", "valley", "nor", "double", "seat", "arrive", "master", "track", "parent", "shore", "division", "sheet", "substance", "favor", "connect", "post", "spend", "chord", "fat", "glad", "original", "share", "station", "dad", "bread", "charge", "proper", "bar", "offer", "segment", "slave", "duck", "instant", "market", "degree", "populate", "chick", "dear", "enemy", "reply", "drink", "occur", "support", "speech", "nature", "range", "steam", "motion", "path", "liquid", "log", "meant", "quotient", "teeth", "shell"]
#Version below is GPT-ready
common_words = ['the', 'of', 'to', 'and', 'a', 'in', 'is', 'it', 'you', 'that', 'he', 'was', 'for', 'on', 'are', 'with', 'as', 'I', 'his', 'they', 'be', 'at', 'one', 'have', 'this', 'from', 'or', 'had', 'by', 'not', 'word', 'but', 'what', 'some', 'we', 'can', 'out', 'other', 'were', 'all', 'there', 'when', 'up', 'use', 'your', 'how', 'said', 'an', 'each', 'she', 'which', 'do', 'their', 'time', 'if', 'will', 'way', 'about', 'many', 'then', 'them', 'write', 'would', 'like', 'so', 'these', 'her', 'long', 'make', 'thing', 'see', 'him', 'two', 'has', 'look', 'more', 'day', 'could', 'go', 'come', 'did', 'number', 'sound', 'no', 'most', 'people', 'my', 'over', 'know', 'water', 'than', 'call', 'first', 'who', 'may', 'down', 'side', 'been', 'now', 'find', 'any', 'new', 'work', 'part', 'take', 'get', 'place', 'made', 'live', 'where', 'after', 'back', 'little', 'only', 'round', 'man', 'year', 'show', 'every', 'good', 'me', 'give', 'our', 'under', 'name', 'very', 'through', 'just', 'form', 'great', 'think', 'say', 'help', 'low', 'line', 'turn', 'cause', 'much', 'mean', 'before', 'move', 'right', 'boy', 'old', 'too', 'same', 'tell', 'does', 'set', 'three', 'want', 'air', 'well', 'also', 'play', 'small', 'end', 'put', 'home', 'read', 'hand', 'port', 'large', 'spell', 'add', 'even', 'land', 'here', 'must', 'big', 'high', 'such', 'follow', 'act', 'why', 'ask', 'men', 'change', 'went', 'light', 'kind', 'off', 'need', 'house', 'picture', 'try', 'us', 'again', 'animal', 'point', 'mother', 'world', 'near', 'build', 'self', 'earth', 'father', 'head', 'stand', 'own', 'page', 'should', 'country', 'found', 'answer', 'school', 'grow', 'study', 'still', 'learn', 'plant', 'cover', 'food', 'sun', 'four', 'between', 'state', 'keep', 'eye', 'never', 'last', 'let', 'thought', 'city', 'tree', 'cross', 'farm', 'hard', 'start', 'might', 'story', 'saw', 'far', 'sea', 'draw', 'left', 'late', 'run', 'while', 'press', 'close', 'night', 'real', 'life', 'few', 'north', 'open', 'together', 'next', 'white', 'children', 'begin', 'got', 'walk', 'example', 'paper', 'group', 'always', 'music', 'those', 'both', 'mark', 'often', 'letter', 'until', 'mile', 'river', 'car', 'feet', 'care', 'second', 'book', 'carry', 'science', 'eat', 'room', 'friend', 'fish', 'stop', 'once', 'base', 'horse', 'cut', 'sure', 'watch', 'color', 'face', 'wood', 'main', 'enough', 'plain', 'girl', 'usual', 'young', 'ready', 'above', 'ever', 'red', 'list', 'though', 'feel', 'talk', 'bird', 'soon', 'body', 'dog', 'family', 'direct', 'pose', 'leave', 'song', 'door', 'product', 'black', 'short', 'class', 'wind', 'question', 'complete', 'ship', 'area', 'half', 'rock', 'order', 'fire', 'south', 'problem', 'piece', 'told', 'pass', 'since', 'top', 'king', 'space', 'heard', 'best', 'hour', 'better', 'true', 'during', 'five', 'remember', 'step', 'early', 'hold', 'west', 'ground', 'interest', 'reach', 'fast', 'verb', 'sing', 'six', 'table', 'travel', 'less', 'morning', 'ten', 'simple', 'war', 'lay', 'against', 'pattern', 'slow', 'center', 'love', 'person', 'money', 'road', 'map', 'rain', 'rule', 'govern', 'pull', 'cold', 'notice', 'voice', 'unit', 'power', 'town', 'fine', 'certain', 'fly', 'fall', 'lead', 'cry', 'dark', 'machine', 'note', 'wait', 'plan', 'figure', 'star', 'box', 'field', 'rest', 'correct', 'able', 'pound', 'done', 'drive', 'stood', 'front', 'week', 'final', 'green', 'oh', 'quick', 'develop', 'warm', 'free', 'minute', 'strong', 'special', 'mind', 'behind', 'clear', 'tail', 'fact', 'street', 'inch', 'nothing', 'course', 'stay', 'wheel', 'full', 'force', 'blue', 'object', 'surface', 'deep', 'moon', 'foot', 'system', 'test', 'record', 'boat', 'common', 'gold', 'plane', 'stead', 'dry', 'laugh', 'ago', 'ran', 'check', 'game', 'shape', 'hot', 'miss', 'heat', 'bring', 'yes', 'fill', 'east', 'language', 'among', 'grand', 'ball', 'yet', 'wave', 'drop', 'heart', 'am', 'present', 'heavy', 'engine', 'position', 'arm', 'wide', 'material', 'size', 'speak', 'weight', 'general', 'ice', 'matter', 'circle', 'pair', 'include', 'felt', 'perhaps', 'pick', 'count', 'square', 'reason', 'length', 'represent', 'art', 'subject', 'region', 'energy', 'hunt', 'bed', 'brother', 'egg', 'ride', 'cell', 'forest', 'sit', 'race', 'window', 'store', 'train', 'sleep', 'leg', 'wall', 'catch', 'mount', 'sky', 'board', 'joy', 'winter', 'sat', 'written', 'wild', 'kept', 'glass', 'grass', 'cow', 'job', 'edge', 'sign', 'past', 'soft', 'fun', 'bright', 'gas', 'weather', 'month', 'million', 'bear', 'happy', 'flower', 'gone', 'jump', 'baby', 'eight', 'meet', 'root', 'buy', 'raise', 'metal', 'whether', 'push', 'seven', 'paragraph', 'third', 'shall', 'held', 'hair', 'cook', 'floor', 'either', 'result', 'burn', 'hill', 'safe', 'cat', 'century', 'consider', 'type', 'law', 'bit', 'copy', 'phrase', 'tall', 'sand', 'roll', 'finger', 'value', 'fight', 'lie', 'beat', 'natural', 'view', 'sense', 'ear', 'else', 'quite', 'case', 'middle', 'kill', 'son', 'lake', 'scale', 'spring', 'child', 'straight', 'nation', 'speed', 'method', 'organ', 'pay', 'age', 'section', 'dress', 'cloud', 'quiet', 'stone', 'tiny', 'cool', 'design', 'poor', 'lot', 'bottom', 'key', 'iron', 'single', 'stick', 'flat', 'skin', 'hole', 'trade', 'trip', 'office', 'row', 'mouth', 'die', 'except', 'wrote', 'seed', 'tone', 'join', 'suggest', 'clean', 'break', 'yard', 'rise', 'bad', 'blow', 'oil', 'blood', 'touch', 'cent', 'mix', 'team', 'wire', 'cost', 'lost', 'brown', 'wear', 'equal', 'sent', 'fell', 'fit', 'flow', 'fair', 'bank', 'collect', 'save', 'control', 'woman', 'practice', 'doctor', 'please', 'protect', 'noon', 'whose', 'ring', 'character', 'period', 'radio', 'atom', 'human', 'history', 'effect', 'electric', 'crop', 'modern', 'element', 'hit', 'student', 'party', 'bone', 'rail', 'agree', 'thus', 'capital', 'chair', 'danger', 'fruit', 'rich', 'process', 'necessary', 'sharp', 'wing', 'create', 'wash', 'bat', 'rather', 'corn', 'string', 'bell', 'depend', 'meat', 'rub', 'tube', 'famous', 'dollar', 'stream', 'sight', 'thin', 'planet', 'chief', 'clock', 'mine', 'tie', 'enter', 'major', 'fresh', 'search', 'send', 'yellow', 'allow', 'print', 'dead', 'spot', 'suit', 'current', 'lift', 'rose', 'continue', 'block', 'chart', 'hat', 'sell', 'success', 'company', 'event', 'deal', 'term', 'wife', 'spread', 'camp', 'born', 'quart', 'nine', 'level', 'chance', 'shop', 'throw', 'shine', 'property', 'column', 'select', 'wrong', 'gray', 'repeat', 'require', 'broad', 'anger', 'claim', 'pretty', 'skill', 'women', 'season', 'silver', 'thank', 'match', 'especially', 'fig', 'huge', 'steel', 'forward', 'similar', 'guide', 'score', 'apple', 'led', 'coat', 'mass', 'card', 'band', 'win', 'dream', 'condition', 'feed', 'tool', 'total', 'basic', 'nor', 'double', 'seat', 'master', 'track', 'parent', 'shore', 'division', 'sheet', 'connect', 'post', 'fat', 'original', 'share', 'station', 'dad', 'bread', 'charge', 'bar', 'offer', 'slave', 'market', 'degree', 'enemy', 'reply', 'support', 'speech', 'nature', 'range', 'steam', 'motion', 'path', 'liquid', 'log', 'shell']