# Demystifying Online Clustering of Bandits: Enhanced Exploration Under Stochastic and Smoothed Adversarial Contexts

This repository contains the source code for reproducing the results of the paper titled "Demystifying Online Clustering of Bandits: Enhanced Exploration Under Stochastic and Smoothed Adversarial Contexts".

## Requirements

```
pip install -r requirements.txt
```

## Repository Structure

-   algorithms: Contains the implementation of the algorithms used in the paper.
    -   Base.py: Contains User, Cluster, and sclub_Cluster classes used in the algorithms.
    -   CLUB.py: CLUB algorithm in [[Gentile et al., 2014]](https://proceedings.mlr.press/v32/gentile14.html).
    -   SCLUB.py: SLUB algorithm in [[Li et al., 2019]](https://dl.acm.org/doi/abs/10.5555/3367243.3367445).
    -   LinUCB.py: LinUCB algorithm in [[Abbasi-Yadkori et al., 2011]](https://proceedings.neurips.cc/paper/2011/hash/e1d5be1c7f2f456670de3d53c7b54f4a-Abstract.html).
    -   UniCLUB.py: UniCLUB algorithm in our paper.
    -   UniSCLUB.py: UniSCLUB algorithm in our paper.
-   env: Contains the implementation of the environments used in the paper.
    -   Environment.py: Environment class.
    -   Arm.py: Arm class.
    -   User.py: User class.
-   data_preprocessing: Contains the implementation of the data preprocessing functions used in the paper.
    - lastfm: data preprocessing for the Last.fm dataset.
    - movielens: data preprocessing for the MovieLens-25M dataset.
    - yelp: data preprocessing for the Yelp dataset.
-   utils: Contains the implementation of the utility functions used in the paper.
    -   utils.py: Utility functions.
-   main.py: Main file to run the experiments.

## How to Run

```
python main.py
```

## Results

Please refer to the paper for the results.

## License

This work is licensed under the terms of the [MIT](LICENSE).
