import random
import sys

import numpy as np


def set_random_seed(seed):
    random.seed(seed)
    np.random.seed(seed)


def get_theta(thetam, num_users, m):
    k = int(num_users / m)
    theta = {i: thetam[0] for i in range(k)}
    for j in range(1, m):
        theta.update({i: thetam[j] for i in range(k * j, k * (j + 1))})
    return theta


def isInvertible(S):
    return np.linalg.cond(S) < 1 / sys.float_info.epsilon
