# Contribution Guidelines

We welcome contributions to JailbreakBench! Feel free to open an issue or a pull request for new contribution.

## With Rye

For this project, we use [rye](https://rye-up.com/). You can install it via:

```bash
curl -sSf https://rye-up.com/get | bash
```

Or follow the official instructions [here](https://rye-up.com/guide/installation/).

Once you are done with the changes, please make sure to run the tests and the linters. You can do this by following the steps below:

```bash
rye fmt
rye lint --fix
rye run mypy .
rye test
```

> [!NOTE]
> In order to run the tests, you need to set the environment variables `TOGETHER_API_KEY` and `OPENAI_API_KEY`. If you didn't make any changes related to the models, you can skip these tests with `rye test -- -m "not api_key"`.

## Without Rye

If you don't want to install rye, then you can install the dependencies in your virtual environment by installing the dev dependencies and the package in editable mode via:

```bash
pip install -r requirements-dev.txt && pip install -e .
```

Once you are done with the changes, please make sure to run the tests and the linters. You can do this by following the steps below:

```bash
ruff --fix .
ruff format .
mypy .
python -m pytest
```

> [!NOTE]
> In order to run all the tests, you need to set the environment variables `TOGETHER_API_KEY` and `OPENAI_API_KEY`. If you didn't make any changes related to the models, you can skip these tests with `python -m pytest -- -m "not api_key"`.
