def register_hparams(defense: type):
    """Global registry of hyperparams. Each item in the _hparams dictionary
    is formatted as _hparam[hyperparameter_name] = hyperparameter_default_value
    New defenses should add entries here.
    """

    hparams = {}

    def _hparam(name, default_value):
        """Define a hyperparameter."""

        assert name not in hparams
        hparams[name] = default_value

    if defense.__name__ == "SmoothLLM":
        _hparam("number_of_copies", 10)
        _hparam("perturbation_type", "RandomSwapPerturbation")
        _hparam("perturbation_pct", 10)

    elif defense.__name__ == "EraseAndCheck":
        _hparam("erase_length", 20)

        # TODO(AR): Change this location
        _hparam("tokenizer_path", "/shared_data0/arobey1/llama-2-7b-chat-hf")

    elif defense.__name__ == "PerplexityFilter":
        _hparam("threshold", 1)

        # TODO(AR): Change this location
        _hparam("perplexity_model_path", "/shared_data0/arobey1/llama-2-7b-chat-hf")

    elif defense.__name__ == "SynonymSubstitution":
        _hparam("substitution_q", 5)

    elif defense.__name__ == "RemoveNonDictionary":
        pass

    # New defense template:
    # if type(defense).__name__ == "MyDefenseName":  # noqa: ERA001
    #     _hparam("my_hyperparameter_name_1", default_value_1)  # noqa: ERA001
    #     _hparam("my_hyperparameter_name_2", default_value_2)  # noqa: ERA001

    else:
        raise ValueError(f"Defense {defense.__name__} not found in defense_hparams.py.")

    return hparams
