from .llm_output import LLMOutput
from .llm_wrapper import LLM


class LLMvLLM(LLM):  # type: ignore
    EXCEPTION = "vLLM is not installed. Run `pip install jailbreakbench[vllm]` to install it."

    def __init__(self, model_name: str):
        super().__init__(model_name)
        raise NotImplementedError(self.EXCEPTION)

    def query_llm(self, inputs: list[list[dict[str, str]]]) -> LLMOutput:
        raise NotImplementedError(self.EXCEPTION)

    def update_max_new_tokens(self, n: int | None):
        raise NotImplementedError(self.EXCEPTION)
