# Requirements
We recommend using a virtual environment with python3.11 (and ours `requirements.txt`)

For example:
```
python3.11 -m venv .venv
. .venv/bin/activate
pip install -r requirements.txt
```

## Libraries 📚
[matplotlib](https://matplotlib.org/),
[cvxpy](https://www.cvxpy.org/),
[numpy](https://numpy.org/), and
[sympy](https://www.sympy.org/en/index.html)

```
pip install matplotlib
pip install cvxpy
pip install numpy
pip install sympy
```

# Code 💻
To run an experyment type 
```
python main.py -id [idnumber]
```

The `idnumber` refers to the experiment.
For example:
> `00`,`01`,`02`, and `03` correspond to the experiments in the paper and `04`, `05` reproduce the graphs in the Introduction.


Have a look at the `main.py` to see the `idnumber` of the graphs in the Appendices. In any case, here is a small description:

> IDs from `10` to `13` are for the experiments under nonuniform sampling.

> IDs from `20` to `23` are for the experiments with $\rho=3$.

> IDs from `30` to `37` are for visualiation plots.

> IDs from `40` to `46` are for the experiments with the jump-diffusion data.

> IDs `50` and `51` prints the total cost per interpolated piece of the experiments in the main document.

The **stability**, **controllability** results have special IDs, e.g.,
```
python main.py -id result
```
```
python main.py -id conjecture
```

You can also print the matrices $A$ and $M$ in the main document for visualization. 
For example:
```
python main.py -id A -rho 2
```
```
python main.py -id M -rho 2 -u 0
```

> Check the help of the parser at the end of `main.py` for more info.

To obtain the excution time presented in one of the appendix tables go to the `main.py` file and set the variable `timeitflag` as `True`.
This will print the average execution time per interpolated piece when runing for example the experiment with ID `00`.

# Interpolator architecture 🛠️
<img src="./img/code_interpolator_architechture.png" width="500">

The interpolator class is constructed on top of the **Spline** class which on turn is constructed on top of the **PolynomialPiece** class.

> This nested architecture has an intuitive motivation, because to interpolate a trajectory you use a spline and splines use polynomial pieces.

The children classes inherit the nested architecture.

The **OnlineInterpolator** class has an additional nested class which is the **SignalState** class.
Again, it is also intuitive to build it this way.