from argparse import ArgumentParser
from cmath import nan
import csv
from sklearn import neighbors
import pandas as pd


parser = ArgumentParser()
parser.add_argument('--trec_file_last', required=True)
parser.add_argument('--trec_file_new', required=True)
parser.add_argument('--save_to', required=True)
args = parser.parse_args()

# Read Predicted Neighbors
neighbors={}
with open(args.trec_file_last,'r') as rf:
	last_lines = rf.readlines()
	q_last=[]
	cur_q, _, p, r, s, _ = last_lines[0].strip().split()
	for i in range(len(last_lines)):
		q, _, p, r, s, _ = last_lines[i].strip().split()
		if q==cur_q:
			q_last.append(i)
		else:
			neighbors[cur_q]=[q_last]
			cur_q=q
			q_last=[i]
	neighbors[q]=[q_last]

with open(args.trec_file_new,'r') as rf:
	new_lines = rf.readlines()
	q_new=[]
	cur_q, _, p, r, s, _ = new_lines[0].strip().split()
	for i in range(len(new_lines)):
		q, _, p, r, s, _ = new_lines[i].strip().split()
		if q==cur_q:
			q_new.append(i)
		else:
			neighbors[cur_q].append(q_new)
			cur_q=q
			q_new=[i]
	neighbors[q].append(q_new)

with open(args.save_to, 'w') as fout:
	for k in neighbors.keys():
		for index in neighbors[k][0]:
			fout.write(last_lines[index].replace('OpenMatch','LastIter'))
		for index in neighbors[k][1]:
			fout.write(new_lines[index].replace('OpenMatch','NewIter'))

print("Successfully finish merging!")