#!/bin/bash

deepspeed ./TGA/train_TGA.py \
    --deepspeed ./TGA/scripts/zero3_fp32.json \
    --model_name_or_path mistralai/Mistral-7B-Instruct-v0.2  \
    --version plain \
    --data_path /path_to_blip_laion_cc_sbu_558k.json \
    --image_folder /path_to_images \
    --vision_tower clip-vit-large-patch14-336   \
    --mm_projector_type mlp2x_gelu \
    --tune_mm_mlp_adapter True \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --bf16 True \
    --output_dir /path_to_output \
    --num_train_epochs 1 \
    --per_device_train_batch_size 32 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 1 \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 2000 \
    --save_total_limit 1 \
    --learning_rate 1e-3 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True