from openai import OpenAI
from gsm.deepseek_tokenizer import count_tokens

client_ds = OpenAI(api_key="", base_url="https://api.deepseek.com/beta")


client_ali = OpenAI(
    api_key="",
    base_url="https://dashscope.aliyuncs.com/compatible-mode/v1",
)


class Agent:
    def __init__(
            self,
            model_name: str,
            no: int,
            token: int,

    ):
        self.model_name = model_name
        self.no = no
        self.token = token

    def calling_api(self, prompt: list[dict[str, str]], logger) -> str:
        global response
        try:

            if self.model_name == "deepseek-chat" or self.model_name == "deepseek-reasoner":
                response = client_ds.chat.completions.create(
                    model=self.model_name,
                    messages= prompt
                )

            if self.model_name in ["qwen1.5-7b-chat", "qwen2.5-math-7b-instruct", "", "deepseek-v3", "qwen2-7b-instruct","qwen2.5-7b-instruct", "qwen1.5-14b-chat", "deepseek-r1-distill-qwen-7b", "qwen2-72b-instruct", "qwen2.5-72b-instruct", "qwen2.5-32b-instruct", "qwen2.5-14b-instruct", "qwen2-7b-instruct", "qwen1.5-32b-chat", "qwen2.5-math-72b-instruct"]:
                response = client_ali.chat.completions.create(
                    model=self.model_name,
                    messages= prompt,
                )


            logger.info("Agent " + str(self.no) + " received: "+ str(prompt))
            logger.info("Agent " + str(self.no) + " " + self.model_name + " calling...")
            logger.info("Agent " + str(self.no) + " " + response.choices[0].message.content)
            self.token += count_tokens(response.choices[0].message.content)
            print(self.token)
            return response.choices[0].message.content

        except Exception as e:
            return "error"
