import json


def load_config(config_path="./config.json"):
    try:
        with open(config_path, "r") as f:
            config = json.load(f)

        return {
            "dataset_path": config.get("dataset_path", ""),
            "dataset_id": config.get("dataset_id", ""),
            "dataset_size": config.get("dataset_size", 0),
            "agent_no": config.get("agent_no", 0),
            "agent_models": config.get("agent_models", []),
            "result_path": config.get("result_path", ""),
            "log_path": config.get("log_path", ""),
            "token_path": config.get("token_path", ""),
            "is_nonconformity": config.get("is_nonconformity", False),
            "round": config.get("round", ""),
            "matrix_file": config.get("matrix_file", ""),
        }
    except FileNotFoundError:
        print(f"{config_path}")
        return None
    except json.JSONDecodeError:
        print(f"{config_path}")
        return None

