import os
from datetime import datetime


class Logger:
    def __init__(self, log_file='log_debate.log_debate', log_level='INFO', max_file_size=1048576, backup_count=5):

        self.log_file = log_file
        self.log_level = log_level.upper()
        self.max_file_size = max_file_size
        self.backup_count = backup_count
        self.level_weights = {
            'INFO': 20,
        }

        log_dir = os.path.dirname(os.path.abspath(self.log_file))
        if log_dir and not os.path.exists(log_dir):
            os.makedirs(log_dir)

    def _should_log(self, level):
        return self.level_weights.get(level, 0) >= self.level_weights.get(self.log_level, 0)


    def _get_file_handle(self):
        if not hasattr(self, '_file_handle'):
            self._file_handle = open(self.log_file, 'a', encoding='utf-8')
        return self._file_handle

    def _write_log(self, level, message):

        timestamp = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        log_entry = f"[{timestamp}] [{level}] {message}\n"

        try:
            file_handle = self._get_file_handle()
            file_handle.write(log_entry)
            file_handle.flush()
        except IOError as e:
            print(f"error: {e}")


    def info(self, message):
        self._write_log('INFO', message)

