# ODEEN

## Installation

Install PyTorch as required by your system, following the [get-started](https://pytorch.org/get-started/locally/).


Install all other required dependencies:
```bash
pip install -r requirements.txt
```

Download the datasets with the following links:

 * [Training Dataset - 1438 rules](https://drive.google.com/file/d/1e3zUsVlCtoPUsi4bA21GBq6tGy0ITkEz/view?usp=sharing)
 * [Training Dataset - 500 rules](https://drive.google.com/file/d/1yIpGwTC1VdSLDfP6hGLicTjiI80gEZl7/view?usp=sharing)
 * [Validation Dataset](https://drive.google.com/file/d/1Ypj-tWwYuXFG80X-9Tuc20VhJhxcvdIz/view?usp=sharing)
 * [Test Dataset](https://drive.google.com/file/d/14XwWNlywNfoX1WkOd0HZTS5E-3Elocmz/view?usp=sharing)

After downloading, move the datasets inside the directory `data`, located in the repository root folder.

## Usage
### Training
It is possible to train the models described in the paper with the following commands.
First, you need move the current directory in the **ODEEN** repository root:
```bash
cd <ODEEN directory>
```
Then, while inside the root directory, you can start the training procedure for the models described in the paper with the following command:
```bash
python ./zendo/learning/trainig.py --config-file "config.json"
```
This will create a folder in the repository root directory named `training_results`. This folder is necessary in order to run the experiments in the paper.

**NOTE:** It is possible to change the configuration file `config.json` (located in the repository root folder) to modify the training procedure.

### Experiments
In order to execute the experiments reported in the paper you can use the following commands.

* **World Labeling Task:** For the results presented in Table 3, run:
	```bash
	python ./zendo/data/experiments/world_labeling.py --config-file "config.json"
	```
* **Rule Induction Task:** For the results presented in paragraph "Generalization power", run:
	```bash
	python ./zendo/data/experiments/rule_induction.py --config-file "config.json"
	```
* **Interpreter Evaluation:** For the results presented in Table 1, run:
	```bash
	python ./zendo/data/experiments/interpreter_analysis.py --config-file "config.json"
	```
* **Rank Analysis:** For the results presented in paragraph "Adjustable thinking time", run:
	```bash
	python ./zendo/data/experiments/rank_analysis.py --config-file "config.json"
	```

**NOTE:** Each command will generate a respective folder in the repository root directory containing the results in json format. In particular, the file 
```bash
python ./zendo/data/experiments/<X>.py --config-file "config.json"
```
will generate the directory `<X>_results`.