from random import choice
from typing import List, Optional

from nltk import CFG
from nltk.grammar import Nonterminal
from nltk.parse.generate import generate
from zendo.game.rule_grammar import zendo_grammar


def generate_all_rules(
    max_rule_depth: Optional[int] = 6,
    max_n: Optional[int] = None,
    start_nonterminal: Optional[Nonterminal] = None,
) -> List[str]:
    """
    Generate rules from the zendo_grammar as defined in the rule
    :param max_rule_depth: maximum rule depth
    :param max_n: maximum number of rules to generate
    :param start_nonterminal: nonterminal to use as start
    :return: list of generated rules
    """
    parsed_grammar = CFG.fromstring(zendo_grammar)
    rules = sorted(
        " ".join(sentence)
        for sentence in generate(
            parsed_grammar, depth=max_rule_depth, n=max_n, start=start_nonterminal
        )
    )
    return rules


if __name__ == "__main__":
    # r = generate_all_rules()
    for x in generate_all_rules(
        max_rule_depth=8, max_n=100, start_nonterminal=Nonterminal("PROP")):
        print(x)
