import numpy as np
from tqdm import tqdm
from scipy.stats import linregress
from scipy.optimize import minimize, fsolve
from algorithm import MultiAgentMirrorDescent, Simulation, SelfConcordantBarrier
from agent import CournotCompetition
import sys
import pickle


# Save parameters
if __name__ == "__main__":
    # parameters to change
    var1 = sys.argv[1]   # n
    var2 = sys.argv[2]   # eta_order
    var3 = sys.argv[3]   # n_repeats
    
    # delta_order = int(var2)/100  
    eta_order = int(var2) / 100  

    path = "/home/XXXX/monotone_attack" # TODO: change you your own path
    n_iter = 20  # for testing purpose, should set to 100000
    
    
    rho = 0.0  # For sanity check purpose
    corruption_constant = 1  # For sanity check purpose
    sigma = 1 # noise variance, degenerated
    n_repeats = 1
    
    # Game Instance parameter
    b = 0.05
    c = 1
    a = 10
    d = 1 # the number of production, which is one dimensional
    B = 50.0 # action radius
    n = int(var1)  # num of player
    
    # Hyperparameters for SCB
    beta = b
    lam = 1
    eta = 1/B
    x_init = np.random.rand(n)*B
    x_init = x_init.tolist()
    def concordant(x):
        B = 50
        #return -np.sum(np.log(x)) - np.sum(np.log(1-x))  # Assume that the action space is unit ball
        return -np.log(B**2-x**2)

    def grad_f(x):
        B = 50
        #return 1/(1-x)-1/x
        return 2*x/(B**2-x**2)

    def hessian_f(x):
        B = 50
        #return 1 / x**2 + 1/(1-x)**2
        return 2*(B**2+x**2)/(B**2-x**2)**2
    
    # Hyperparameters for MAMD
    iter = 1
    r = 0.5 * B
    p = 0.5 * B # centered point
    d = 1 # the number of production, which is one dimensional
    delta_zero = B  # it requires delta_zero / r < 1
    gamma_zero = B
    
    # Create instances
    competition = CournotCompetition(a = a, b = b, c = 1, n = n, rho = rho, sigma=sigma, iter = iter, corruption_constant = corruption_constant)
    # MAMD = MultiAgentMirrorDescent(n = n, r = r, p = p, d = d, x_init = x_init, delta = delta_zero, gamma = gamma_zero, competition=competition, B = B, sanity_check=True)
    # MAMD.set_order(delta_order = delta_order, gamma_order = 3 * delta_order)
    SCB = SelfConcordantBarrier(n=n, x_init = x_init, d = d, eta = eta, beta=beta, lam=lam, concordant=concordant, grad_f = grad_f, hessian_f = hessian_f, competition=competition, B = B, sanity_check=True)
    SCB.set_order(eta_order = eta_order)
    env = Simulation(game_instance=competition, algorithm=SCB)
    m, k, l, j, z, v = env.run_simulation(n_iter = n_iter, corrupted=False, n_repeats=n_repeats, return_full_data=True)
    # m, k, l, j = env.run_simulation(n_iter = n_iter, corrupted=False, n_repeats=1, return_full_data=True)

    # Save projects to directed folder
    idx = int(var3)
    with open(f"{path}/cournot/SCB/convergence_{n}_{eta_order}_{idx}.json", 'wb') as f:
            pickle.dump(k, f)
    with open(f"{path}/cournot/SCB/divergence_{n}_{eta_order}_{idx}.json", 'wb') as f:
            pickle.dump(j, f)
    with open(f"{path}/cournot/SCB/budget_{n}_{eta_order}_{idx}.json", 'wb') as f:
            pickle.dump(v, f)
