import numpy as np

def identity_func(data):
    return data

    
def fabricated_spacing(data):
    # Add a new point between each pair of points in data
    midpoints = (data[:-1] + data[1:]) / 2
    new_data = np.empty(len(data) + len(midpoints))
    new_data[0::2] = data
    new_data[1::2] = midpoints
    return new_data


def fabricated_trimmed(data):
    # Remove 5% of the data from each end
    num_trimmed = int(0.05 * len(data))
    return data[num_trimmed:-num_trimmed]


def add_coin_flips(data):
    # Add 25% of the length of data of 50/50 0s and 1s 
    num_fabricated_data = int(len(data) * 0.25)
    coin_flips = np.random.choice([0, 1], size=num_fabricated_data, p=[0.5, 0.5])
    new_dataset = np.concatenate((data, coin_flips))
    np.random.shuffle(new_dataset)
    return new_dataset


def add_bern_samples(data):
    # Add 25% of the length of data of Bernoulli samples with p dependent on the data
    num_fabricated_data = int(len(data) * 0.25)
    frac_ones = np.sum(data) / len(data)
    new_samples = np.random.choice([0,1], size=num_fabricated_data, p=[1-frac_ones, frac_ones])
    new_dataset = np.concatenate((data, new_samples))
    np.random.shuffle(new_dataset)
    return new_dataset