# Implementation Instruction

## Setup

Preprocessed data is presented in `data/eval_data/`. Download model ckpts of [gpt2-xl](https://huggingface.co/gpt2-xl) and [opt-6.7b](https://huggingface.co/facebook/opt-6.7b) into local directories.

## Coefficients Estimation

Run `python estimate_mu.py --ckpt_path /path/to/ckpt --oracle_data_path /path/to/data/file`

- `/path/to/ckpt` should be the path to model ckpt.
- `/path/to/data/file` should be the path to dev data file, e.g., `data/eval_data/wikitext/dev_full.csv`.

## Run sampling

Run `python sample.py --data_path /path/to/data --main_model_ckpt /path/to/ckpt --mu /path/to/mu`

- `/path/to/data` should be the path to data, e.g., `data/eval_data/wikitext`.
- `/path/to/ckpt` should be the path to model ckpt.
- `/path/to/mu` should be the path to the optimal mu.

We also provide full generations of baselines and our models in `data`.