%% ZCA whitening by Cadieu
function [zcaMatrix,center] = whiten( X, pixel_noise_variance_cutoff_ratio, pixel_noise_fractional_variance )
center = mean(X,2); 
X = X - center;   %- Subtract mean
C = X*X'/size(X,2);
%clear X
[E, D] = eig(C);
[~, sind] = sort(diag(D),'descend');
d = diag(D);
d = d(sind);
E = E(:,sind);

% determine cutoff:
variance_cutoff = pixel_noise_variance_cutoff_ratio...
    * pixel_noise_fractional_variance ...
    * var(X(:));
m.M = sum(d>variance_cutoff); % number of valid dims
varX = d(1:m.M);
factors = real(varX.^(-.5));
E = E(:,1:m.M);
D = diag(factors);

zcaMatrix = E*D*E';
