%
% learn generator for image rotations around center
% use imrotate
%
%%
clearvars;%close all
bivec = @(v1,v2) (v1*v2'-v2*v1');
vcos = @(v1,v2) (dot(v1(:),v2(:))/norm(v1(:))/norm(v2(:)));
%% params
par.len=22;
par.dcut=8;
par.kk=40;%floor(n/2);
par.angleMax=45; % degrees
par.iter=2e6;
par.etaSVD=0.02;
par.etaPCA=0.0002;
par.rndseed=2021;
rng(par.rndseed);
disp(par)
%% image params
center=par.len/2+.5;
dist=sqrt( ((1:par.len)-center).^2+((1:par.len)-center)'.^2 );
mask=dist<=par.dcut;
%figure,imagesc(mask)
n=sum(mask(:)); % vector length
remask=find(mask); % to restore image
[r,c]=find(mask);
diam=max(c)-min(c)+1; % size of active region
cutout=min(c):max(c); % size of active region
%% SVD prep
angles=par.angleMax*rand(1,par.iter);
u=randn(n,par.kk);u=u./vecnorm(u);
v=randn(n,par.kk);v=v./vecnorm(v);
aveChi=zeros(n);
du=nan(1,par.iter);
%% SVD loop
tic;
for i=1:par.iter
 
    [x,y] = genRotPair(par.len,mask,angles(i));    
    [u1,v1] = skewGhaXYStep(x,y,u,v,par.etaSVD);
    du(i)=norm([u,v]-[u1,v1],'fro');
    u=u1; v=v1;
    
    aveChi = aveChi*(1-1/par.iter) + (y*x'-x*y')/par.iter;
    
    if rem(i,par.iter/20)==0
        fprintf('%d    %f  %f\n', i, toc, max(abs(u(:)))); end
    
end
disp(['SVD time ',num2str(toc),' sec'])
%figure,plot(du)
%%
tilefig(par,cutout,remask,u,v); title('SVD');
%%
function [x,y] = genRotPair(len,mask,angle)
    img=rand(len);
    x_=img(mask);
    x=x_/norm(x_);
    imrot=imrotate(img,angle,'bilinear','crop');
    y_=imrot(mask);
    y=y_/norm(y_);
end
%%
function tilefig(par,cutout,remask,uu,vv)
    figure;
    %pos=get(gcf,'Position');pos(3)=(par.kk/2)*pos(4);set(gcf,'Position',pos);
    tiles=tiledlayout(8,par.kk/4,'TileSpacing','none','Padding','none');
    for i=1:par.kk
        uimg=zeros(par.len);
        uimg(remask)=uu(:,i);
        nexttile(i),imagesc(uimg(cutout,cutout)),colormap('gray'),xticklabels([]),yticklabels([]);axis equal tight;
        %title(ds(2*i,2*i));
        vimg=zeros(par.len);
        vimg(remask)=vv(:,i);
        nexttile(par.kk+i),imagesc(vimg(cutout,cutout)),colormap('gray'),xticklabels([]),yticklabels([]);axis equal tight;
    end
end
