## Usage

1. Install [mmdetection](https://github.com/open-mmlab/mmdetection/blob/master/docs/get_started.md)

2. Download COCO 2017 from the [official website](https://cocodataset.org/#download) and prepare the dataset. The directory structure should look like

   ```
   coco
   ├── annotations
   ├── train2017
   └── val2017
   ```



## Training

```bash
cd detection
python setup.py install
bash tools/dist_train.sh  <CONFIG_FILE> <GPU_NUM> --cfg-options model.pretrained=<PRETRAIN_MODEL> [model.backbone.use_checkpoint=True] [other optional arguments] 
```

For example, you can train FAT-B3 with 8 GPUs by

```
bash tools/dist_train.sh configs/FAT/retinanet_b3.py 8 --cfg-options model.pretrained=FAT-B3.pth
```


## Benchmark

To get the FLOPs, run

```bash
python tools/get_flops.py configs/FAT/retinanet_b3.py
```

This should give

```bash
Input shape: (3, 1280, 800)
Flops: 242.68 GFLOPs
Params: 38.92 M
```

## Results

#### RetinaNet

|Backbone | Params (M) | FLOPs (G) | box AP |
|---------|------------|-----------|--------|
|FAT-B0   |13.8        |165.6      |40.4    |
|FAT-B1   |17.3        |175.5      |42.5    |
|FAT-B2   |23.2        |193.5      |44.0    |
|FAT-B3   |38.9        |242.7      |45.9    |

#### Mask R-CNN
|Backbone |Params (M)  | FLOPs (G) | box AP | mask AP |
|---------|------------|-----------|--------|---------|
|FAT-B0   |24.3        |183.8      |40.8    |37.7     |
|FAT-B1   |27.5        |193.9      |43.3    |39.6     |
|FAT-B2   |33.1        |212.1      |45.2    |41.3     |
|FAT-B3   |48.8        |261.3      |47.6    |43.1     |