# T5 Multi-Task Fine-Tuning

This project implements multi-task fine-tuning of T5 models on GLUE benchmark tasks using various techniques including LoRA and UnoLoRA.

## Table of Contents

1. [Environment Setup](#environment-setup)
2. [Project Structure](#project-structure)
3. [Task-Specific Scripts](#task-specific-scripts)
4. [Running Experiments](#running-experiments)
5. [Monitoring and Logging](#monitoring-and-logging)

## Environment Setup

1. Ensure you have Python 3.8+ installed on your system.

2. Setup the environment using the environment.sh script. This script installs miniconda and then sets up a new conda environment with the required packages.

3. Please remember to change the project name, entity name in the wandb.init() function in each script to your project name.

## Project Structure

The project is organized as follows:

- `t5-mnli.py`: Script for fine-tuning on MNLI task
- `t5-mrpc.py`: Script for fine-tuning on MRPC task
- `t5-qnli.py`: Script for fine-tuning on QNLI task
- `t5-sst2.py`: Script for fine-tuning on SST-2 task
- `t5-stsb.py`: Script for fine-tuning on STS-B task
- `unolora.py`: Implementation of UnoLoRA technique
- `shared_lora_run.py`: Script for running experiments with the single shared LoRA adapter

## Task-Specific Scripts

Each task-specific script (`t5-mnli.py`, `t5-mrpc.py`, etc.) follows a similar structure:

1. Data preprocessing functions for the specific task
2. Dataset preparation and loading
3. Model initialization with LoRA configuration
4. Training loop and evaluation functions

The `unolora.py` script implements the UnoLoRA technique for multi-task learning.

## Running Experiments

To run an experiment for a specific task, use the corresponding script. For example:

1. For MNLI task:
   ```
   python t5-mnli.py
   ```

2. For MRPC task:
   ```
   python t5-mrpc.py
   ```

3. For QNLI task:
   ```
   python t5-qnli.py
   ```

4. For SST-2 task:
   ```
   python t5-sst2.py
   ```

5. For STS-B task:
   ```
   python t5-stsb.py
   ```

6. To run the UnoLoRA experiment:
   ```
   python unolora.py
   ```

Before running any experiment, ensure that you have:
- Activated your virtual environment
- Logged in to Weights & Biases
- Set the appropriate hyperparameters in the script (e.g., batch size, learning rate)

## Monitoring and Logging

Experiments are logged using Weights & Biases. To view the results:

1. Go to your Weights & Biases dashboard (https://wandb.ai)
2. Select your project.
3. Click on the specific run you want to analyze.

The dashboard will show metrics such as loss, accuracy, and other task-specific evaluations over the course of training.

## Notes

- Ensure you have sufficient GPU resources available for training, especially for larger tasks like MNLI.
- The scripts use a fixed random seed (42) for reproducibility. You can modify this if needed.
- Adjust the `batch_size`, `learning_rate`, and other hyperparameters in the scripts to optimize performance for your specific hardware setup.