# CMGNN
This is a unified codebase for heterophilic graph neural networks, including 19 baseline methods, one novel method CMGNN, and 13 datasets. 

## Baseline Methods
* **MLP**: Multilayer perceptron
* **GCN**: Semi-supervised Classification with Graph Convolutional Networks (ICLR 2017)
* **GAT**: Graph Attention Networks (ICLR, 2018)
* **APPNP**: Predict then Propagate: Graph Neural Networks meet Personalized PageRank (ICLR 2019)
* **GCNII**: Simple and Deep Graph Convolutional Networks (ICML 2020)
* **MixHop**: Higher-Order Graph Convolutional Architectures via Sparsified Neighborhood Mixing (ICML 2019)
* **H2GCN**: Beyond Homophily in Graph Neural Networks: Current Limitations and Effective Designs (NeurIPS 2020)
* **GBKGNN**: Gated Bi-Kernel Graph Neural Networks for Modeling Both Homophily and Heterophily (WWW 2022)
* **GGCN**: Two Sides of the Same Coin: Heterophily and Oversmoothing in Graph Convolutional Neural Networks (ICDM 2022)
* **GloGNN**: Finding Global Homophily in Graph Neural Networks When Meeting Heterophily (ICML 2022)
* **HOGGCN**: Powerful Graph Convolutioal Networks with Adaptive Propagation Mechanism for Homophily and Heterophily (AAAI 2022)
* **GPRGNN**: Adaptive Universal Generalized PageRank Graph Neural Network (ICLR 2021)
* **ACMGCN**: Revisiting Heterophily for Graph Neural Networks (NeurIPS 2022)
* **OrderedGNN**: Ordered GNN: Ordering Message Passing to Deal with Heterophily and Over-smoothing (ICLR 2023)
* **CLP**: Simplifying Node Classification on Heterophilous Graphs with Compatible Label Propagation (TMLR 2022)
* **EPFGNN**: Explicit pairwise factorized graph neural network for semi-supervised node classification (UAI 2021)
* **CPGNN**: Graph Neural Networks with Heterophily (AAAI 2021)
* **M2MGNN**: Sign is Not a Remedy: Multiset-to-Multiset Message Passing for Learning on Heterophilic Graphs (ICML 2024)
* **N2**: Towards Dynamic Message Passing on Graphs (NeurIPS 2024)


## Datasets
The datasets used in the codebase include:
* **Small scale**: **Roman-Empire**, **Amazon-Ratings**, **Chameleon-F**, **Squirrel-F**, **Actor**, **Flickr**, **BlogCatalog**, and **Pubmed**;
* **Large Scale**: **Penn94**, **Twitch-Gamer**, **Genius**, **Pokec**, and **Snap-Patents**.



## How to Run

### Baseline Methods
The presearched parameters are listed in '/config/baseline/{model_type}.yaml'. 

    python main.py --model_type={model_type} --dataset={dataset}

Note the dataset name is the script should use plain lowercase letters, e.g. for Chameleon-F dataset with "--dataset=chameleonf".

### Compatibility Matrix-aware GNN (CMGNN)

    python main.py --model_type=CMGNN --dataset={dataset}


## Main Requirements
* python >= 3.6.13
* numpy >= 1.19.2
* pytorch >= 1.10.2
* dgl-cuda >= 0.8.1
* torch-geometric >= 2.0.3