## Environment configuration
We provide an env.yml file that can be used to initialize a conda environment, though we recommend the use of micromamba (https://mamba.readthedocs.io/en/latest/user_guide/micromamba.html) to get things up and going more quickly. 

Additionally, we rely on sdeint, which can be installed through pip:

```bash
pip install sdeint
```

To install FCCA, navigate to the FCCA directory and run:

```bash
pip install -e .
```

For RNN training, we assume a version of torch compatible with cuda is installed. This can be done in a separate environment using the env_cuda.yml file.

## Data Access

All data files, both synthetic and in (hippcampal) neural data, needed to run the experiments from the manuscript can be accessed at https://figshare.com/s/98a577ed14789153ee28. To follow along the instructions below, you should move these files to the appropriate subfolders.

## Synthetic E/I network experiments 

The scripts in this section rely either on mpi4py or joblib to execute things in parallel. You should tune the number of MPI processes or number of joblib jobs to suit the resources available to you locally.

The file Amats.pkl stores all synthetic matrices used in the experiments. These matrices can be (stochastically) generated by running

```bash
python soc.py
```

First, to replicate the results of Figure 2 on the LDS cross-covariances, run:

```bash
mpirun -n N python soc_ccm.py Amats.pkl ./soc_ccm_output_path
```
where N should be set to the number of processes you would like to parallelize over. Set N=1 to run in serial mode.

To replicate the results of Figure 2 on the Poisson process simulations (Count LDS), run the following three scripts:

```bash
python gen_soc_activity.py Amats.pkl ./soc_activity_tmp N
```
where N should be set to the number of processes you would like to parallelize over. Set N=1 to run in serial mode. Next, run:

```bash
mpirun -n N soc_poisson_sim.py Amats.pkl ./soc_activity_tmp ./soc_poisson_sim_output
```

Followed by:

```bash
python soc_poisson_dimreduc.py ./soc_poisson_sim_output ./soc_poisson_output_path N
```

To replicate the results of Supplementary Figure 1 requires running two scripts. First:

```bash
python gen_soc_activity_ns.py Amats.pkl ./soc_activity_ns_tmp N
```

Followed by:
```bash
mpirun -n N python soc_ns_dimreduc.py Amats.pkl ./soc_activity_ns_tmp ./soc_ns_output_path
```

Code to plot the results is provided in soc_plots.ipynb. For convenience, we have included consolidated versions of the above results in the files soc_df.pkl, soc_poisson_df.pkl, and soc_ns_df.pkl

## Task optimized RNNs

Models are initialized from matrices located in Alist_rnn.pkl

Raw EMG data, pre-trained RNNs, as well as pre-computed dimensionality reduction results can be obtained from the figshare link. Raw EMG data should be placed in the data folder.

To train RNNs from scratch, one can run:

```bash
python rnn/run_Dale.py
```

To perform dimensionality reduction on the trained RNNs, run:

```bash
python rnn/dimreduc_concat.py
```

To plot results, run:

```bash
python rnn/plot_RNN.py
```

## Experiments in data

The data file containing the (hippocampal) neural data is called hpc_data.obj. All experiments invovling the neural data can be re-run as follows:

```bash
python hpc/hpc_experiments.py
```