# ZORO

A Python implementation of the ZORO algorithm, as introduced in *Zeroth-order regularized optimization (ZORO): Approximately sparse gradients and adaptive sampling* by Cai, McKenzie, Yin and Zhang. This paper is accepted to SIAM Journal on Optimization (SIOPT). Preprint available <a href=https://arxiv.org/abs/2003.13001> here </a>.

ZORO, and its adaptive variant AdaZORO, are implemented as classes in `optimizers.py`. We use the `BaseOptimizer` class as in [this](https://github.com/NiMlr/High-Dim-ES-RL) Repo.

## Requirements
Python 3.5+. For proximal operators the `pyproximal` package is required.

## Examples
See `Test.py`, `Test_Prox.py` and `Test_Ada.py` for examples of using ZORO.

## Questions?
Feel free to contact us at dmckenzie@mines.edu or hqcai@ucf.edu.

## Recommended citation
If you find this code useful please use the following citation:
```
  @article{cai2022zeroth,
    title={Zeroth-order regularized optimization (ZORO): Approximately sparse gradients and adaptive sampling},
    author={Cai, HanQin and Mckenzie, Daniel and Yin, Wotao and Zhang, Zhenliang},
    journal={SIAM Journal on Optimization},
    volume={32},
    number={2},
    pages={687--714},
    year={2022},
    publisher={SIAM}
  }
```
