{{- define "socialnetwork.templates.media-service.nginx.conf"  }}
# Checklist: Make sure that worker_processes == #cores you gave to
# nginx process
worker_processes  16;

# error_log  logs/error.log;

# Checklist: Make sure that worker_connections * worker_processes
# is greater than the total connections between the client and Nginx.
events {
  worker_connections  1024;
}

env fqdn_suffix;

http {
  include       mime.types;
  default_type  application/octet-stream;

  log_format main '$remote_addr - $remote_user [$time_local] "$request"'
                  '$status $body_bytes_sent "$http_referer" '
                  '"$http_user_agent" "$http_x_forwarded_for"';
  # access_log  logs/access.log  main;

  sendfile        on;
  tcp_nopush      on;
  tcp_nodelay     on;

  # Checklist: Make sure the keepalive_timeout is greateer than
  # the duration of your experiment and keepalive_requests
  # is greateer than the total number of requests sent from
  # the workload generator
  keepalive_timeout  120s;
  keepalive_requests 100000;

  # Docker default hostname resolver
  resolver {{ .Values.global.nginx.resolverName }} valid=10s ipv6=off;

  lua_package_path '/usr/local/openresty/nginx/lua-scripts/?.lua;/usr/local/openresty/luajit/share/lua/5.1/?.lua;;';

  lua_shared_dict config 32k;

  init_by_lua_block {
    local upload = require "resty.upload"
    local memcached = require "resty.memcached"
    local mongo = require "resty-mongol"
  }

  server {

    # Checklist: Set up the port that nginx listens to.
    listen       8080 reuseport;
    server_name  localhost;

    # Checklist: Turn of the access_log and error_log if you
    # don't need them.
    access_log  off;
    # error_log off;

    client_max_body_size 100M;
    client_body_buffer_size 100M;

    # Checklist: Make sure that the location here is consistent
    # with the location you specified in wrk2.
    location /upload-media {
          if ($request_method = 'OPTIONS') {
            add_header 'Access-Control-Allow-Origin' '*';
            add_header 'Access-Control-Allow-Methods' 'GET, POST, OPTIONS';
            add_header 'Access-Control-Allow-Headers' 'DNT,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Range';
            add_header 'Access-Control-Max-Age' 1728000;
            add_header 'Content-Type' 'text/plain; charset=utf-8';
            add_header 'Content-Length' 0;
            return 204;
          }
          if ($request_method = 'POST') {
            add_header 'Access-Control-Allow-Origin' '*';
            add_header 'Access-Control-Allow-Methods' 'GET, POST, OPTIONS';
            add_header 'Access-Control-Allow-Headers' 'DNT,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Range';
            add_header 'Access-Control-Expose-Headers' 'Content-Length,Content-Range';
          }
          if ($request_method = 'GET') {
            add_header 'Access-Control-Allow-Origin' '*';
            add_header 'Access-Control-Allow-Methods' 'GET, POST, OPTIONS';
            add_header 'Access-Control-Allow-Headers' 'DNT,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Range';
            add_header 'Access-Control-Expose-Headers' 'Content-Length,Content-Range';
          }
      content_by_lua '
        local client = require "upload-media"
        client.UploadMedia();
      ';
    }

    # Checklist: Make sure that the location here is consistent
    # with the location you specified in wrk2.
    location /get-media {
          if ($request_method = 'OPTIONS') {
            add_header 'Access-Control-Allow-Origin' '*';
            add_header 'Access-Control-Allow-Methods' 'GET, POST, OPTIONS';
            add_header 'Access-Control-Allow-Headers' 'DNT,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Range';
            add_header 'Access-Control-Max-Age' 1728000;
            add_header 'Content-Type' 'text/plain; charset=utf-8';
            add_header 'Content-Length' 0;
            return 204;
          }
          if ($request_method = 'POST') {
            add_header 'Access-Control-Allow-Origin' '*';
            add_header 'Access-Control-Allow-Methods' 'GET, POST, OPTIONS';
            add_header 'Access-Control-Allow-Headers' 'DNT,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Range';
            add_header 'Access-Control-Expose-Headers' 'Content-Length,Content-Range';
          }
          if ($request_method = 'GET') {
            add_header 'Access-Control-Allow-Origin' '*';
            add_header 'Access-Control-Allow-Methods' 'GET, POST, OPTIONS';
            add_header 'Access-Control-Allow-Headers' 'DNT,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Range';
            add_header 'Access-Control-Expose-Headers' 'Content-Length,Content-Range';
          }
      content_by_lua '
        local client = require "get-media"
        client.GetMedia();
      ';
    }

  }
}
{{- end }}
