set -x  # Print commands as they run

# Initialize conda for non-interactive shell
eval "$(conda shell.bash hook)"

# CausalNF
cd causal-profiler-experiments/CausalNF
conda create -y --name causal_nf python=3.9.12 --no-default-packages
conda activate causal_nf
pip install torch==1.13.1 torchvision==0.14.1 --index-url https://download.pytorch.org/whl/cpu
pip install torch-scatter==2.1.1 -f https://data.pyg.org/whl/torch-1.13.0+cpu.html
pip install torch_geometric==2.3.1
pip install -r requirements.txt
cd ../causal-profiler
pip install -e .
pip install pyyaml
cd -
conda deactivate
# DCM
cd ../DCM
conda env create -y -f environment.yml
conda activate dcm
pip install torch==1.11.0+cpu -f https://download.pytorch.org/whl/cpu/torch_stable.html
pip install matplotlib
cd ../causal-profiler
pip install -e .
pip install pyyaml
cd -
conda deactivate
# DeCaFlow
cd ../DeCaFlow
conda create -y --name decaflow_env python=3.11 --no-default-packages
conda activate decaflow_env
pip install git+https://github.com/probabilists/zuko
pip install causalflows==0.1.0 torch==2.5.1 lightning==2.5.1 pandas seaborn pytest jupyter cdt
cd ../causal-profiler
pip install pyyaml
pip install -e .
cd -
conda deactivate
# NCM
cd ../NCM
conda create -y --name ncm_env python=3.11 --no-default-packages
conda activate ncm_env
cd ../causal-profiler
pip install -e .
pip install pyyaml
cd -
pip install -r requirements-noversion.txt
conda deactivate
# VACA (linux only)
cd ../VACA
conda create -y --name vaca python=3.9 --no-default-packages
conda activate vaca
cd ../causal-profiler
pip install torch==1.10.0+cpu torchvision==0.11.1+cpu torchaudio==0.10.0+cpu -f https://download.pytorch.org/whl/torch_stable.html
pip install numpy==1.26.4
pip install -e . --no-deps
cd -
# sudo apt install build-essential # you need g++
pip install torch-scatter torch-sparse torch-cluster torch-spline-conv torch-geometric -f https://data.pyg.org/whl/torch-1.10.0+cpu.html
pip install torch-sparse==0.6.12
pip install pytorch-lightning==1.4.9 --no-deps
pip install torchmetrics==0.6.2 --no-deps
pip install setuptools==59.5.0
pip install networkx==2.8.2
pip install seaborn==0.11.2
pip install scikit-learn
pip install pyyaml pyDeprecate==0.3.1
pip install future
pip install tensorboard==2.7.0
pip install matplotlib==3.5.2
pip install protobuf==3.20.3
pip uninstall -y torch-geometric
pip install torch-geometric==2.0.4
conda deactivate