#!/bin/bash
#SBATCH --job-name=airl_baseline_warmstart
#SBATCH -o ANONYMOUS
#SBATCH -c 8
#SBATCH -t 15:59:00
#SBATCH --mem=4G
#SBATCH -M ANONYMOUS
#SBATCH -p short
#
#SBATCH --array=1-20

cd ANONYMOUS
. ./scirl
cd ScIRL/

n=$SLURM_ARRAY_TASK_ID
sleep $((${n} + 1))


mkdir -p results/airl_results_warmstart/

#id,lr_disc,linear_g
python -u mdenv_airl.py --traj_dir ANONYMOUS/trajectories/mdtoyenv/scalability/3/ --random_seed ${n} --id ${n} --lr_disc 0.001 --linear_g 1 --expert_data_ind $((${n} - 1)) --wandb_name airl_baseline --warmstart 1