#generate random search inputs
import numpy as np
import pandas as pd
file_name = "experiment_params/mdenv_cari_training.csv"
param_names = ["max_training_steps","update_every","k_epochs","eps_clip","lr_actor","lr_critic","gamma","lamb","bs","random_seed","n_pseudo", "entropy_coef", "n_weights", "smooth_reward", "n_env_dim"]
N = 10
params = np.zeros((N, len(param_names)))
params = pd.DataFrame(params)
params.columns = param_names
#set/sample the values
# params.max_training_steps = 1000000
# params.update_every = np.random.choice(np.arange(1,7), N)
# params.k_epochs = np.random.choice(np.arange(5,40, 5), N)
# params.eps_clip = np.random.choice(np.linspace(0.05, 0.2, 11), N)
# params.lr_actor = np.random.choice(np.linspace(0.001, 0.01, 11), N)
# params.lr_critic = np.random.choice(np.linspace(0.001, 0.1, 11), N)
# params.gamma = np.random.choice(np.linspace(0.9, 0.999, 11), N)
# params.lamb = np.random.choice(np.linspace(0.9, 0.999, 11), N)
# params.bs = np.random.choice(2**np.arange(9, 14), N)
# params.random_seed = np.random.choice(np.arange(55, 5555), N)
# params.n_pseudo = np.random.choice(np.arange(0, 2), N)
# params.entropy_coef = np.random.choice(np.linspace(0.001, 0.1, 11), N)
# #params.n_weights = np.random.choice(np.arange(2, 10), N)
# params.n_weights = 3
# #params.smooth_reward = np.random.choice((0, 1), N)
# params.smooth_reward = 1

#single with random seeds, with 0 or 1 weights
params.max_training_steps = 3000000
params.update_every = 3
params.k_epochs = 35
params.eps_clip = 0.125
params.lr_actor = 0.005
params.lr_critic = 0.021
params.gamma = 0.91
params.lamb = 0.959
params.bs = 2048
params.random_seed = 5274
params.n_pseudo = 0
params.entropy_coef = 0.031
params.n_weights = np.arange(2, 2*N)[:N]
params.smooth_reward = 1
params.n_env_dim = 8

#add the default params
#dtypes = params.dtypes.copy()
#params.loc[params.shape[0]] =  [params.max_training_steps[0],4,20,0.2,0.003,0.01,0.99,0.95,4096,0,3,0.01]
#cast back to original dtypes
#params = params.astype(dtypes)

params.round(3).to_csv(file_name, sep=",", index=False, header=True)