#generate random search inputs
import numpy as np
import pandas as pd
import os
file_name = "scalability_params.csv"
param_names = ["N_goals", "N_weights", "random_seed", "policy_paths", "N_trajs", "random_seed"]
N_weights = 20 #number of random samples to generate

policy_dir = "ANONYMOUS/PPO_preTrained_m5/mdtoyenv"
policy_paths = [f"{policy_dir}/{f}" for f in os.listdir(policy_dir) if f.endswith(".pth")]
weight_key = [int(f.replace(".pth", "")) for f in os.listdir(policy_dir) if f.endswith(".pth")]

params = np.zeros((len(weight_key), len(param_names)))
params = pd.DataFrame(params)
params.columns = param_names

#for generating trajectories
params.N_goals = weight_key
params.N_weights = N_weights
params.policy_paths = policy_paths
params.N_trajs = 128
params.random_seed = 113

#for irl

params.round(3).to_csv(file_name, sep=",", index=False, header=True)