import sys
import torch
import models
class ModelConstructor:
    """Wrapper around the Environment to expose a cleaner interface for RL

        Parameters:
            env_name (str): Env name


    """
    def __init__(self, state_dim, action_dim, hidden_size, actor_seed=None, critic_seed=None):
        """
        A general Environment Constructor
        """
        self.state_dim = state_dim
        self.action_dim = action_dim
        self.hidden_size = hidden_size
        self.actor_seed = actor_seed
        self.critic_seed = critic_seed


    def make_model(self, name, seed=False):
        """
        Generate and return an model object
        """
        try:
            model = getattr(models, name)(self.state_dim, self.action_dim, self.hidden_size)
            if seed:
                model.load_state_dict(torch.load(self.critic_seed))
                print('Critic seeded from', self.critic_seed)
            return model
        except:
            print("Unknwon Model Type")
            sys.exit()