import argparse
from envs.gym_wrapper import GymWrapper
from envs.gfootball import GFootball


class EnvConstructor:
    """Wrapper around the Environment to expose a cleaner interface for RL

        Parameters:
            env_name (str): Env name


    """
    def __init__(self, env_name, config, frameskip, num_agents, T):
        """
        A general Environment Constructor
        """
        self.env_name, self.config, self.frameskip, self.num_agents, self.T = env_name, config, frameskip, num_agents, T

        if env_name == 'gfootball':
            self.is_discrete = True
            self.state_dim = 115
            self.action_dim = 19


        elif self.env_name == 'gym':

            dummy_env = GymWrapper(config, frameskip=self.frameskip)
            self.is_discrete = dummy_env.is_discrete
            self.state_dim = dummy_env.state_dim
            self.action_dim = dummy_env.action_dim
            self.num_agents = 1

        elif self.env_name == 'test':
            from envs.gfootball import Navigation
            self.state_dim = 4
            self.action_dim = 5
            self.num_agents = 1



    def make_env(self, **kwargs):
        """
        Generate and return an env object
        """
        if self.env_name == 'gfootball':
            env = GFootball(self.frameskip,
                            self.T,
                            self.config,
                            self.action_dim,
                            self.num_agents,
                            render=False,
                            trace_path='Results/gfootball_trace',
                            tracedump=False)

        elif self.env_name == 'gym':
            env = GymWrapper(self.config, self.frameskip)

        elif self.env_name == 'test':
            env = Navigation(self.config)
        else:
            Exception('Wrong Env Choice')


        return env



