from core.utils import pprint, str2bool
from core.params import Parameters
import numpy as np, os, time, torch
import core.utils as mod
import argparse
import random
from utils.model_constructor import ModelConstructor
from envs.constructor import EnvConstructor

"""
ENV = gfootball | gym
CONFIGS = academy_3_vs_1_with_keeper
          11_vs_11_easy_stochastic
          11_vs_11_hard_stochastic.py
          11_vs_11_stochastic.py
          5_vs_5
          1_vs_1_easy
          academy_empty_goal

"""

RANDOM_BASELINE = False



if __name__ == "__main__":

    #######################  Construct ARGS Class to hold all parameters ######################
    parser = argparse.ArgumentParser(description="Config file")
    parser.add_argument('--config_file', type=str, default='./configs/discrete_baselines.json', help='Configuration file for the chosen model')
    parser.add_argument('--config_idx', type=str, default=1, help='Configuration index')
    exp_info = parser.parse_args()
    print(exp_info.config_file)
    args = Parameters(exp_info)

    # # Set seeds
    torch.manual_seed(args.seed); np.random.seed(args.seed); random.seed(args.seed)

    ################################## Find and Set MDP (environment constructor) ########################
    env_constructor = EnvConstructor(args.env_name, args.config, args.frameskip, args.num_agents, args.T)
    #######################  Actor, Critic and ValueFunction Model Constructor ######################
    model_constructor = ModelConstructor(env_constructor.state_dim, env_constructor.action_dim, args.hidden_size)


    print('Running ', args.env_name, 'with config ', args.config, 'State_dim:', env_constructor.state_dim,
          'Action_dim', env_constructor.action_dim, 'Ratio', args.ratio)

    if args.agent_type == 'autobot':
        print("I am building agent")
        from agents.autobot.autobot_trainer import Autobot_Trainer
        ai = Autobot_Trainer(args, model_constructor, env_constructor)
    elif args.agent_type == 'sr':
        from agents.sr.sr_trainer import SR_Trainer
        ai = SR_Trainer(args, model_constructor, env_constructor)

    else:
        Exception('Agent Type has to be either autobot | sr')

    ai.train()
