#!/bin/bash

# Usage check
if [ "$#" -ne 1 ]; then
    echo "Usage: $0 <root_path>"
    exit 1
fi

# Capture the root path from the first script argument
root=$1

# Loop from 1000 to 10000 with steps of 1000
for it in {0..25000..500}; do
    echo "Processing iteration $it..."
    # Call Python script for reporting batch run images
    python scripts/report_batch_run_images.py $root $it
    # Call Shell script for reporting batch run videos
    ./scripts/report_batch_run_videos.sh $root $it

    echo "Iteration $it processing complete."
done

echo "All iterations processed."
