import os
import shutil
from PIL import Image
from crop_subimg import crop_sub_image

# Call the function with CLI arguments
out_dir = "report_comp_imgs"

if __name__ == '__main__':
    import sys
    if len(sys.argv) not in [2, 3]:
        print("Usage: python crop_subimg.py <root_path> <iteration>")
        exit()
    
    root_path = sys.argv[1]
    iteration = 8500
    if len(sys.argv) > 2:
        iteration = int(sys.argv[2])

    # clean the report_imgs directory
    shutil.rmtree(out_dir, ignore_errors=True)
    os.makedirs(out_dir, exist_ok=True)
    
    run_folders = os.listdir(root_path)
    for view_idx in [0, 5, 10, 15, 45, 40]:
        out_view_dir = os.path.join(out_dir, str(view_idx))
        os.makedirs(out_view_dir, exist_ok=True)
        
        for run_dir in run_folders:
            if "@" not in run_dir:
                continue
            iteration_path = os.path.join(root_path, run_dir, "save", f"it{iteration}-test")
            prompt_name = os.path.basename(run_dir).split('@')[0]
            
            img_path = os.path.join(iteration_path, f"{view_idx}.png")
            crop_sub_image(img_path, 0, 2, f"{out_view_dir}/{prompt_name}.png")
            crop_sub_image(img_path, 1, 2, f"{out_view_dir}/geo_{prompt_name}.png")
        
    
    # zip the directory
    shutil.make_archive(out_dir, 'zip', out_dir)
    print(f"Saved arxive to {out_dir}.zip")
        
    
