#!/bin/bash

# Function to wait for all jobs in the current batch to finish
wait_for_jobs() {
    local job_pid
    for job_pid in "$@"; do
        wait $job_pid
    done
}

# Declare an array of experiments where each element is "description, parameters"
declare -a experiments=(
    "New default,                   ours-inversion.yaml,   "

    "Early shading,                 ours-inversion.yaml,   system.material.ambient_only_steps=0"
    "Delayed shading,               ours-inversion.yaml,   system.material.ambient_only_steps=4000"

    "Higher ambient prob,           ours-inversion.yaml,   system.material.diffuse_prob=0.4"
    "No texturless prob,            ours-inversion.yaml,   system.material.textureless_prob=0."

    "Random t,                      ours-inversion.yaml,   system.guidance.sqrt_anneal=false"
    "No noise,                      ours-inversion.yaml,   system.guidance.inversion_eta=0."

    # "Hessian convex loss 1.,         ours-inversion.yaml,    system.loss.lambda_convex_hess=1. system.loss.lambda_convex=0. system.renderer.return_depth_d=true"
    # "Hessian convex loss start,      ours-inversion.yaml,    system.loss.lambda_convex_hess=[0,1.,0.1,4000] system.loss.lambda_convex=0. system.renderer.return_depth_d=true"
    # "Hessian convex loss 1. 16,      ours-inversion.yaml,    system.convexity_res=16 system.loss.lambda_convex_hess=1. system.loss.lambda_convex=0. system.renderer.return_depth_d=true"
    
    # "Sparsity no sqrt,               ours-inversion.yaml,    system.sqrt_sparcity_loss=false"
    # "Sparsity relu 0.2,              ours-inversion.yaml,    system.threshold_sparcity_loss=0.2"
    # "Sparsity relu 0.3,              ours-inversion.yaml,    system.threshold_sparcity_loss=0.3"
    # "Sparsity relu 0.4,              ours-inversion.yaml,    system.threshold_sparcity_loss=0.4"

    # "Cat overfitted default,        ours-inversion.yaml,    "
    # "No perp neg,                     ours-inversion.yaml,    system.prompt_processor.use_perp_neg=false"
    # "Smaller sparcity loss,           ours-inversion.yaml,    system.loss.lambda_sparsity=[0,0.1,0.,3000]"
    # "No orient loss,                  ours-inversion.yaml,    system.loss.lambda_orient=0."
    # "No z variance loss,              ours-inversion.yaml,    system.loss.lambda_z_variance=0."
    # "No sparcity loss,                ours-inversion.yaml,    system.loss.lambda_sparsity=0."
    # "No perp neg stronger entropy,   ours-inversion.yaml,    system.prompt_processor.use_perp_neg=false system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=0.5"
    # "No perp neg stronger entropy,   ours-inversion.yaml,    system.prompt_processor.use_perp_neg=false system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=0.5"
    # "No perp neg ours prompt aug2,   ours-inversion.yaml,    system.prompt_processor.use_perp_neg=false system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=0.5 system.guidance.prompt_augmentation_cfg_scale=2."
    # "No perp neg ours prompt aug1.5, ours-inversion.yaml,    system.prompt_processor.use_perp_neg=false system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=0.5 system.guidance.prompt_augmentation_cfg_scale=1.5"
    # "More Inversion steps 2,         ours-inversion.yaml,    system.guidance.ddim_inverse_n_steps=20"

    # "backed up 10 steps,                                 ours-inversion-backup.yaml,    system.guidance.ddim_inverse_n_steps=10"
    # "backed up no downscaling,                           ours-inversion-backup.yaml,    system.renderer.return_comp_normal=true system.guidance.ddim_inverse_n_steps=10 data.width=512 data.height=512 data.resolution_milestones=[] data.batch_size=1"
    # "backed up mean loss no downscaling,                 ours-inversion-backup.yaml,    system.renderer.return_comp_normal=true system.guidance.ddim_inverse_n_steps=10 system.guidance.loss_reduction='mean' system.loss.lambda_orient=0.1 system.loss.lambda_z_variance=1. system.loss.lambda_sparsity=[0,0.15,0.,3000] system.loss.lambda_convex=[0,1.,0.1,4000] system.loss.lambda_opaque=0.1 data.width=512 data.height=512 data.resolution_milestones=[] data.batch_size=1"
    # "backed up 10 steps mean loss,                       ours-inversion-backup.yaml,    system.renderer.return_comp_normal=true system.guidance.ddim_inverse_n_steps=10 system.guidance.loss_reduction='mean' system.loss.lambda_orient=0.1 system.loss.lambda_z_variance=1. system.loss.lambda_sparsity=[0,0.15,0.,3000] system.loss.lambda_convex=[0,1.,0.1,4000] system.loss.lambda_opaque=0.1"
    # "backed up 10 steps mean loss fovy,                  ours-inversion-backup.yaml,    system.renderer.return_comp_normal=true system.guidance.ddim_inverse_n_steps=10 system.guidance.loss_reduction='mean' system.loss.lambda_orient=0.1 system.loss.lambda_z_variance=1. system.loss.lambda_sparsity=[0,0.15,0.,3000] system.loss.lambda_convex=[0,1.,0.1,4000] system.loss.lambda_opaque=0.1 data.camera_distance_range=[1.5,2.0] data.fovy_range=[50,70] data.width=[64,256,512] data.height=[64,256,512] data.resolution_milestones=[1000,5000] data.batch_size=[1,1,1]"
    # "backed up 10 steps mean loss fovy,                  ours-inversion-backup.yaml,    system.renderer.return_comp_normal=true system.guidance.ddim_inverse_n_steps=10 system.guidance.loss_reduction='mean' system.loss.lambda_orient=0.1 system.loss.lambda_z_variance=1. system.loss.lambda_sparsity=[0,0.15,0.,3000] system.loss.lambda_convex=[0,1.,0.1,4000] system.loss.lambda_opaque=0.1 data.camera_distance_range=[1.5,2.0] data.fovy_range=[50,70] data.width=[64,256,512] data.height=[64,256,512] data.resolution_milestones=[1000,5000] data.batch_size=[1,1,1]"
    # "backed up,                                          ours-inversion-backup.yaml,    "
    # "Smaller sparcity loss stronger convexity,           ours-inversion.yaml,           system.loss.lambda_sparsity=[0,0.05,0.,3000] system.loss.lambda_convex=[0,2.,0.1,4000]"
    # "backed up mean loss no downscaling,                 ours-inversion-backup.yaml,    system.renderer.return_comp_normal=true system.guidance.ddim_inverse_n_steps=10 system.guidance.loss_reduction='mean' system.loss.lambda_orient=0.1 system.loss.lambda_z_variance=1. system.loss.lambda_sparsity=[0,0.15,0.,3000] system.loss.lambda_convex=[0,1.,0.1,4000] system.loss.lambda_opaque=0.1 data.width=256 data.height=256 data.resolution_milestones=[] data.batch_size=1"
    
    # "new default before ablation,   ours-inversion.yaml,    trainer.max_steps=5000 system.guidance.trainer_max_steps=5000"
    # "re-scaled loss,                ours-inversion.yaml,    trainer.max_steps=5000 system.guidance.trainer_max_steps=5000 system.guidance.loss_reduction='mean' system.loss.lambda_orient=1. system.loss.lambda_z_variance=1."
    # "re-scaled loss adj,            ours-inversion.yaml,    trainer.max_steps=5000 system.guidance.trainer_max_steps=5000 system.guidance.loss_reduction='mean' system.loss.lambda_orient=1. system.loss.lambda_z_variance=1. system.rescale_additional_losses=50"
    # "re-scaled loss adj 2,          ours-inversion.yaml,    trainer.max_steps=5000 system.guidance.trainer_max_steps=5000 system.guidance.loss_reduction='mean' system.loss.lambda_orient=.1 system.loss.lambda_z_variance=0.1 system.loss.lambda_sparsity=0.1"
    # "new default after new resolution milestone,   ours-inversion.yaml,   "
    # "rescaled losses,                              ours-inversion.yaml,     system.guidance.loss_reduction=mean system.loss.lambda_orient=1. system.loss.lambda_z_variance=1. system.loss.lambda_opaque=0.1 system.loss.lambda_sparsity=0.3"
    # "rescaled losses + convexity 0.2,              ours-inversion.yaml,     system.guidance.loss_reduction=mean system.loss.lambda_orient=1. system.loss.lambda_z_variance=1. system.loss.lambda_opaque=0.1 system.loss.lambda_sparsity=0.1 system.loss.lambda_convex=0.2"
    # "rescaled losses + convexity 1.0,              ours-inversion.yaml,     system.guidance.loss_reduction=mean system.loss.lambda_orient=1. system.loss.lambda_z_variance=1. system.loss.lambda_opaque=0.1 system.loss.lambda_sparsity=0.1 system.loss.lambda_convex=1.0"

    # "smaller lr,                    ours-inversion.yaml,            system.optimizer.args.lr=0.003 system.optimizer.params.geometry.lr=0.003"
    # "stronger geom losses,          ours-inversion.yaml,            system.loss.lambda_orient=2000 system.loss.lambda_sparsity=100. system.loss.lambda_opaque=100. system.loss.lambda_z_variance=600."
    # "stronger geom l smaller lr,    ours-inversion.yaml,            system.optimizer.args.lr=0.003 system.optimizer.params.geometry.lr=0.003 system.loss.lambda_orient=2000 system.loss.lambda_sparsity=100. system.loss.lambda_opaque=100. system.loss.lambda_z_variance=600."
    

    # "HIFA,                          hifa.yaml,  "

    # Fix sparsity loss
    # "Downscale extra losses,        ours-inversion.yaml,           system.rescale_additional_losses=100. "
    # "No sparsity loss,              ours-inversion.yaml,           system.loss.lambda_sparsity=0. "

    # "Geometric losses,              ours-inversion.yaml,           system.loss.lambda_sparsity=10. system.loss.lambda_opaque=[2000,0.0,1000.0,2001] system.loss.lambda_z_variance=300."
    # "SDS loss scaling,              ours-inversion.yaml,           system.guidance.use_sds_scaling=true"
    # "View dependet prompt front,    ours-inversion.yaml,           system.prompt_processor.view_dependent_prompt_front=true"
    # "Slowly increase resolution,    ours-inversion.yaml,           data.width=[64,512] data.height=[64,512] data.batch_size=[1,1] data.resolution_milestones=[1000]"

    # Prompt experiments
    # "Prompt aug no front aug,       ours-inversion.yaml,           system.guidance.prompt_augmentation_cfg_scale=2.  system.guidance.inversion_eta=0.5 system.prompt_processor.view_dependent_prompt_front=true"
    # "CFG dependent on the angle 5,  ours-inversion.yaml,           system.guidance.back_cfg_scale=5. system.guidance.inversion_eta=0.5"
    # "perp neg,                      ours-inversion.yaml,           system.prompt_processor.use_perp_neg=true system.guidance.inversion_eta=0.5"

    # Misc
    # "Presize timesteps,             ours-inversion.yaml,           system.guidance.use_legacy_scheduler=false"
    # "cfg=2.0 no noise,              ours-inversion.yaml,           system.guidance.guidance_scale=2.0 system.guidance.inverse_guidance_scale=-2.0 system.guidance.inversion_eta=0."
    # "cfg=2.0 little noise,          ours-inversion.yaml,           system.guidance.guidance_scale=2.0 system.guidance.inverse_guidance_scale=-2.0 system.guidance.inversion_eta=0.1"
    # "Positive CFG on prediction,    ours-inversion.yaml,           system.guidance.inverse_guidance_scale=10.0 system.guidance.use_legacy_scheduler=false"

    # "no material,                   ours-inversion-no-mat.yaml, "
    # "stronger sparsity loss,        ours-inversion-no-mat.yaml,    system.loss.lambda_sparsity=10."
    # "no mat geometry radius = 1,    ours-inversion-no-mat.yaml,    system.geometry.radius=1."
    # "random background,             ours-inversion.yaml,           system.background.random_aug=true"
    # "sqrt time annealing,           ours-inversion.yaml,           system.guidance.t_map_power=0.5"
    # "sqrt entropy anneling,         ours-inversion.yaml,           system.guidance.inversion_entropy_power=0.5"
    # "inversion_cfg=0.5,             ours-inversion.yaml,           system.guidance.inverse_guidance_scale=-0.5"
    # "azimuth entropy + grad acc,    ours-inversion.yaml,           trainer.accumulate_grad_batches=3"

    # CFG ablation
    # "cfg=2.0,                       ours-inversion.yaml,     system.guidance.guidance_scale=2.0 system.guidance.inverse_guidance_scale=-2.0"
    # "cfg=7.5,                       ours-inversion.yaml,     system.guidance.guidance_scale=7.5 system.guidance.inverse_guidance_scale=-7.5"
    # "cfg=15,                        ours-inversion.yaml,     system.guidance.guidance_scale=15  system.guidance.inverse_guidance_scale=-15"
    # "cfg=40,                        ours-inversion.yaml,     system.guidance.guidance_scale=40  system.guidance.inverse_guidance_scale=-40"
    # "cfg=100,                       ours-inversion.yaml,     system.guidance.guidance_scale=100 system.guidance.inverse_guidance_scale=-100"

    # Azimuth dependant entropy
    # "Azimuth entropy 0.2,          ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true"
    # "Azimuth entropy 0.5,          ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=0.5"
    # "Azimuth entropy 1.0,          ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=1.0"
    # "Azimuth entropy 1.0 no rand,  ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=1.0 system.guidance.inversion_t_threshold=1000"
    # "Azimuth entropy 0.5 no rand,  ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=0.5 system.guidance.inversion_t_threshold=1000"
    # "Azimuth entropy 2.0 no rand,  ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=2.0 system.guidance.inversion_t_threshold=1000"
    # "Azimuth entropy 1.0 longer,   ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=1.0 system.guidance.inversion_t_threshold=1000 trainer.max_steps=25000 system.guidance.trainer_max_steps=25000"
    # "Azimuth entropy 5.0 no rand,  ours-inversion.yaml,    system.guidance.linear_inversion_entropy=true system.guidance.inversion_eta=5.0 system.guidance.inversion_t_threshold=1000"

    # "Acc grad 3 +-40 front,      ours-inversion.yaml,    trainer.accumulate_grad_batches=3  data.azimuth_range=[-40,40]"
    # "Acc grad 5 +-40 front,      ours-inversion.yaml,    trainer.accumulate_grad_batches=5  data.azimuth_range=[-40,40]"
    # "Acc grad 5,                 ours-inversion.yaml,    trainer.accumulate_grad_batches=5"
    # "Acc grad 5 10k steps,                 ours-inversion.yaml,    trainer.accumulate_grad_batches=5  trainer.max_steps=10000 system.guidance.trainer_max_steps=10000"

    # Accumulate gradient ablation
    # "Acc grad 3 shorter,              ours-inversion.yaml,    trainer.accumulate_grad_batches=3 trainer.max_steps=2000 system.guidance.trainer_max_steps=2000 system.run_test_every=400"
    # "Acc grad 3,                      ours-inversion.yaml,    trainer.accumulate_grad_batches=3"
    # "Acc grad 10 shorter,             ours-inversion.yaml,    trainer.accumulate_grad_batches=10 trainer.max_steps=500 system.guidance.trainer_max_steps=500 system.run_test_every=50"
    # "Acc grad 10,                     ours-inversion.yaml,    trainer.accumulate_grad_batches=10 trainer.max_steps=2000 system.guidance.trainer_max_steps=2000 system.run_test_every=200"
    # "Acc grad 50,                     ours-inversion.yaml,    trainer.accumulate_grad_batches=50 trainer.max_steps=500 system.guidance.trainer_max_steps=500 system.run_test_every=50"
    # "Acc grad 10 short front views,   ours-inversion.yaml,    trainer.accumulate_grad_batches=10 trainer.max_steps=500 system.guidance.trainer_max_steps=500 system.run_test_every=50 data.azimuth_range=[-15,15]"

    # # Random sampling of t
    # "randomly sample t,         ours-inversion.yaml,    system.guidance.sqrt_anneal=false"
    # "randomly sample t>0.4,     ours-inversion.yaml,    system.guidance.sqrt_anneal=false system.guidance.min_step_percent=0.4"
    # "randomly sample t>0.2,     ours-inversion.yaml,    system.guidance.sqrt_anneal=false system.guidance.min_step_percent=0.2"

    # # LR ablation
    # "LR 0.03,                   ours-inversion.yaml,    system.optimizer.args.lr=0.03"
    # "LR 0.005,                  ours-inversion.yaml,    system.optimizer.args.lr=0.005 trainer.max_steps=10000 system.guidance.trainer_max_steps=10000"
    # "LR 0.1,                    ours-inversion.yaml,    system.optimizer.args.lr=0.1"

    # # LR geom ablation
    # "geom LR 0.03,              ours-inversion.yaml,    system.optimizer.params.geometry.lr=0.03"
    # "geom LR 0.005,             ours-inversion.yaml,    system.optimizer.params.geometry.lr=0.005 trainer.max_steps=10000 system.guidance.trainer_max_steps=10000"
    # "geom LR 0.1,               ours-inversion.yaml,    system.optimizer.params.geometry.lr=0.1"

    # TODO geometry type ablation
    # TODO ablate CFG small and big
    # TODO ablate materials
)

# Loop through the experiments array
for experiment in "${experiments[@]}"; do
    IFS=',' read -r description config params <<< "$experiment"

    echo "Starting batch: $description with params: $params"
    
    # Call your job launch script here, and collect PIDs
    ./mass_run.sh "$description" $config $params &
    pid=$!
    
    # Wait for the current batch to finish
    wait_for_jobs $pid
    
    echo "Batch '$description' completed."
done

echo "All batches have been processed."

