import os

def parse_directory(path):
    # Get all subdirectories
    subdirs = [name for name in os.listdir(path) if os.path.isdir(os.path.join(path, name))]
    
    # Process each subdirectory name
    processed_names = []
    for subdir in subdirs:
        # Replace underscores with spaces and cut after the at sign
        processed_name = subdir.replace('_', ' ').split('@')[0]
        processed_names.append(processed_name)
    
    # Write the processed names to a text file
    output_path = os.path.join(path, 'subdirectories_names.txt')
    with open(output_path, 'w') as f:
        for name in processed_names:
            f.write(f"\"{name}\"\n")
    
    print(f"Processed subdirectory names have been written to {output_path}")

# Specify the path to your directory
directory_path = '/mnt/XXXX-2/playground/SDS/thirdparty/threestudio/outputs/full_runs/20240513_122008_InterestingPromptsNoShaders/ours-inversion'
parse_directory(directory_path)
