import voyageai
import numpy as np
from typing import List
from tqdm.auto import tqdm

# vo = voyageai.Client()


def get_voyage_embedding(prompt: str, model="voyage-2", input_type=None):
    response = vo.embed([prompt], model=model, input_type=input_type)
    return np.array(response.embeddings[0])


def get_voyage_embeddings_batched(
    prompts: List[str],
    batch_size=128,
    model="voyage-2",
    input_type=None,
    pbar=True,
):
    assert batch_size <= 128, "voyage limits batch size at 128"

    num_batches = max(int(len(prompts) / batch_size + 0.99), 1)
    embeddings = []
    for i in tqdm(range(num_batches), disable=not pbar):
        inputs = prompts[i * batch_size : (i + 1) * batch_size]
        response = vo.embed(texts=inputs, model=model, input_type=input_type)
        embedding = response.embeddings
        embeddings.append(embedding)
    embeddings = np.hstack(embeddings)
    return embeddings
