
#. Mene. For certain debugging purposes

def print_shape(obj, name = None, layer = 0):
    if isinstance(obj, dict):
        print('\t'*layer + '%s(dict):' % name if name else '')
        for k, v in obj.items():
            print_shape(v, k, layer = layer+1)
    elif isinstance(obj, list) or isinstance(obj, tuple):
        print('\t'*layer + '%s(iter):' % name if name else '')
        for v in obj:
            print_shape(v, layer = layer+1)
    else:
        if hasattr(obj, 'shape'):
            print('\t'*layer + "%s: %s" % (name if name else '', str(obj.shape)))
        else:
            print('\t'*layer + "%s: %s" % (name if name else '', type(obj)))
