import sys
import os
sys.path.append(os.getcwd())
import shutil
import cv2
import torch
import torch.nn as nn
import torch.nn.functional as F
import torchvision
from torch.utils.data import Dataset, dataloader
import numpy as np
from torchvision.transforms import Compose, ToTensor, PILToTensor, RandomHorizontalFlip
from torchvision import transforms
from torch.utils.data import DataLoader
from torchvision.datasets import DatasetFolder
import torchvision.models as models
import core
import argparse
from PIL import Image
from UNet_ResNet18 import U64R18
 
parser = argparse.ArgumentParser(description='PyTorch BadNets_CIFAR10')
parser.add_argument('--gpu_id', default='3', type=str,
                    help='id(s) for CUDA_VISIBLE_DEVICES')
 
args = parser.parse_args()
state = {k: v for k, v in args._get_kwargs()}

os.environ["CUDA_VISIBLE_DEVICES"] = args.gpu_id
 
# ========== Set global settings ==========
global_seed = 666
deterministic = True
torch.manual_seed(global_seed)
CUDA_VISIBLE_DEVICES = args.gpu_id
datasets_root_dir = './data/cifar10'
save_path = './CIFAR10/BadNets'
res_path = os.path.join(save_path, 'Test')
if os.path.exists(res_path):
    shutil.rmtree(res_path)
os.mkdir(res_path)

unet_dir_path = os.path.join(save_path, 'UNet_ResNet18_CIFAR10_BadNets')

unet_dir = []
for unetnames in os.listdir(unet_dir_path):
    if unetnames.startswith('ResNet18'):
        unet_dir.append(os.path.join(unet_dir_path, unetnames))
shuffle_path = os.path.join(unet_dir_path, 'label_shuffle.pth')
 
transform_test = Compose([
    ToTensor()
])
 
testset = DatasetFolder(root=os.path.join(datasets_root_dir, 'val'),
                         transform=transform_test,
                         loader=cv2.imread,
                         extensions=('png',),
                         target_transform=None,
                         is_valid_file=None,
                         )
 

pattern = torch.load(os.path.join(save_path, 'pattern.pth'))

weight = torch.zeros((32, 32), dtype=torch.float32)
weight[-3:, -3:] = 1.0

for unet_path in unet_dir:

    print(f'----------------Test the original backdoored model ... ----------------\n')

    badnets = core.BadNets(
        train_dataset=testset,
        test_dataset=testset,
        model=U64R18(save_path, unet_path, shuffle_path).net,
        loss=nn.CrossEntropyLoss(),
        y_target=0,
        poisoned_rate=0.1,
        pattern=pattern,
        weight=weight,
        seed=global_seed,
        deterministic=deterministic
    )

    schedule = {
        'device': 'GPU',
        'CUDA_VISIBLE_DEVICES': CUDA_VISIBLE_DEVICES,
        'GPU_num': 1,
    
        'benign_training': False,
        'batch_size': 128,
        'num_workers': 2,
    
        'lr': 0.1,
        'momentum': 0.9,
        'weight_decay': 5e-4,
        'gamma': 0.1,
        'schedule': [150, 180],
    
        'epochs': 200,
    
        'log_iteration_interval': 100,
        'test_epoch_interval': 10,
        'save_epoch_interval': 20,
    
        'save_dir': res_path,
        'experiment_name': 'Poisoned_ResNet18_CIFAR10_BadNets'
    }
    badnets.test(schedule)

    print(f'----------------Test the original backdoored model with REFINE ... ----------------\n')

    badnets = core.BadNets(
        train_dataset=testset,
        test_dataset=testset,
        model=U64R18(save_path, unet_path, shuffle_path),
        loss=nn.CrossEntropyLoss(),
        y_target=0,
        poisoned_rate=0.1,
        pattern=pattern,
        weight=weight,
        seed=global_seed,
        deterministic=deterministic
    )

    schedule = {
        'device': 'GPU',
        'CUDA_VISIBLE_DEVICES': CUDA_VISIBLE_DEVICES,
        'GPU_num': 1,
    
        'benign_training': False,
        'batch_size': 128,
        'num_workers': 2,
    
        'lr': 0.1,
        'momentum': 0.9,
        'weight_decay': 5e-4,
        'gamma': 0.1,
        'schedule': [150, 180],
    
        'epochs': 200,
    
        'log_iteration_interval': 100,
        'test_epoch_interval': 10,
        'save_epoch_interval': 20,
    
        'save_dir': res_path,
        'experiment_name': 'REFINE_Poisoned_ResNet18_CIFAR10_BadNets'
    }
    badnets.test(schedule)
    # break

