import pickle
import numpy as np
import matplotlib.pyplot as plt

import sys
sys.path.append('../')
import expUtils

fnames = ['output/compareLocalMinQuality_gridSearch.pkl',
          'output/compareLocalMinQuality_gradientDescent.pkl',
          'output/compareLocalMinQuality_TestObjective_ratio-N=50.pkl',
          'output/compareLocalMinQuality_KFoldCV-N=50-K=5.pkl',
          'output/compareLocalMinQuality_KFoldCV-N=50-K=10.pkl',
]
titles = ['Severity of grid search',
          'Severity of grad. descent',
          'Severity (test loss)',
          'Severity of 5-fold CV',
          'Severity of 10-fold CV',]
saveNames = ['gridSearch',
             'gradientDescent',
             'testLoss',
             '5Fold',
             '10Fold']



for ii in range(len(fnames)):
  try:
    f = open(fnames[ii], 'rb')
    res = pickle.load(f)
    f.close()
  except:
    from IPython import embed;np.set_printoptions(linewidth=80);embed()

  if ii > 1:
    fs = 25
  else:
    fs = 22
  plt.figure()
  expUtils.plotLocalMinQuality(res['ratio'],
                      res['phis'],
                      res['alphas'],
                               titles[ii],
                               fs=fs)

  plt.savefig(f'/home/will/projects/model_selection/neurips2021/figs/compareLocalMinQuality_{saveNames[ii]}.png',
              layout='tight')
  
  #plt.show()
