### Free Hunch: Denoiser Covariance Estimatino for Diffusion Models Without Extra Costs

The codebase is based on the EDM2 code (https://github.com/NVlabs/edm2), and borrows some parts from the DPS codebase (https://github.com/DPS2022/diffusion-posterior-sampling) and the "Improving Diffusion Models for Inverse Problems Using Optimal Posterior Covariance" codebase (https://github.com/xypeng9903/k-diffusion-inverse-problems). 

### Requirements
The requirements.txt file should have the relevant packages (and possibly some redundant ones as well for now).

### Download the neural network weights
Download the 256x256 diffusion model weights from the following link and put them in the ```models/``` folder:
```bash 
cd models
wget https://openaipublic.blob.core.windows.net/diffusion/jul-2021/256x256_diffusion_uncond.pt
```

### Running the code
Running FH without online updates:
```bash
python generate_conditional.py --total_images=10 --image_base_covariance=dct_diagonal --operator_name=gaussian_blur --num_steps=15 --do_space_updates=False
```
Running FH with online updates:
```bash
python generate_conditional.py --total_images=10 --image_base_covariance=dct_diagonal --operator_name=gaussian_blur --num_steps=15 --use_online_updates=True
```
Running PiGDM as a baseline:
```bash
python generate_conditional.py --total_images=10 --operator_name=gaussian_blur --num_steps=15 --conditioning_mechanism=pigdm
```

### Dataset
We have provided a tiny, preprocessed version of the ImageNet dataset (~20 images) in the ```data/``` folder in order to run the models. It also contains the DCT diagonal covariance matrix. 

### Calculating the DCT coefficients
If you want to calculate the DCT coefficients yourself, you can run
```bash
python do_frequency_analysis.py
```
and change the imagenet_data_dir in the file to the path of the dataset you want to use This will generate a file called ```dct_coefficients.pt```, which contains the values for the variances along the different DCT components. 