import os

def get_job_name_params(cfg):
    """
    Get the parameters to include in the job name
    """
    key_shorthands = {
            'operator_name': 'op',
            'noise_sigma': 'ns',
            'solver': 'slv',
            'num_steps': 'stp',
            'S_churn': 'ch',
            'total_images': 'img',
            'cond_scaling': 'cs',
            'image_base_covariance': 'ibc',
            'pca_component_count': 'pca',
            'denoiser_mean_error_threshold': 'det',
            'use_analytical_score_time_update': 'atu',
            'project_to_diagonal': 'ptd',
            'space_step_update_threshold': 'sut',
            'space_step_update_lower_threshold': 'slt',
            'pigdm_posthoc_scaling': 'pps',
            'clip_x0_mean': 'cx0m',
            'conditioning_mechanism': 'cm',
    }
    # No need to add the measurement operators etc., since they are included in the experiment name
    keys_to_include = []
    if cfg['conditioning_mechanism'] == 'dps':
        keys_to_include.append(['operator_name', 'noise_sigma', 'solver', 'num_steps', 'S_churn', 'total_images', 'cond_scaling'])
        return {k: v for k, v in cfg.items() if k != 'outdir' and k in keys_to_include}
    elif cfg['conditioning_mechanism'] == 'pigdm' or cfg['conditioning_mechanism'] == 'tmpd' or cfg['conditioning_mechanism'] == 'peng_convert' or cfg['conditioning_mechanism'] == 'peng_analytic':
        keys_to_include.append(['operator_name', 'noise_sigma', 'solver', 'num_steps', 'S_churn', 'total_images', 'cond_scaling', 'pigdm_posthoc_scaling', 'clip_x0_mean'])
        # Transform the dictionary to use shorthands if the shorthands are defined
        original_dict = {k: v for k, v in cfg.items() if k != 'outdir' and k in keys_to_include}
        return {key_shorthands.get(k, k): v for k, v in original_dict.items()}
    elif cfg['conditioning_mechanism'] == 'online_covariance':
        keys_to_include.append(['operator_name', 'noise_sigma', 'solver', 'num_steps', 'S_churn', 'total_images', 'cond_scaling', 'image_base_covariance', 'pca_component_count', 'denoiser_mean_error_threshold', 'use_analytical_score_time_update', 'project_to_diagonal', 'space_step_update_threshold', 'space_step_update_lower_threshold', 'pigdm_posthoc_scaling', 'clip_x0_mean', 'max_rtol', 'use_analytic_var_at_end'])
        # Get the original dictionary
        original_dict = {k: v for k, v in cfg.items() if k != 'outdir' and k in keys_to_include}
        # Transform the dictionary to use shorthands
        return {key_shorthands.get(k, k): v for k, v in original_dict.items()}
    else:
        raise ValueError(f"Unknown conditioning mechanism: {cfg['conditioning_mechanism']}")
