from cleanfid import fid
import argparse


def main(args):
    
    # Compute FID
    fid_score = fid.compute_fid(args.gen_folder, args.reference_folder)

    print('======')
    print('## args.gen_folder: ', args.gen_folder)
    print('## args.reference_folder: ', args.reference_folder)
    print('fid_score: ', fid_score)
    print('======')


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--gen_folder', type=str, help='Folder containing the generated images')
    parser.add_argument('-r', '--reference_folder', type=str, help='Folder containing the real images')

    args = parser.parse_args()

    main(args)