
from typing import List, Callable

def int2devicestr(device_id: int):
    if device_id < 0:
        return "cpu"
    else:
        return f"cuda:{device_id}"

def batch_prediction(inputs: List[str], fn: Callable[[List[str]], List[float]], batch_size: int, verbose: bool = False):
    outputs = []
    idx = 0
    while idx < len(inputs):
        start_idx = idx
        end_idx = min(start_idx + batch_size, len(inputs))
        if verbose:
            print(inputs[start_idx:end_idx])
        outputs += fn(inputs[start_idx:end_idx])
        idx = end_idx
    return outputs